;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;; Le module                                                                 
(module
  __caml_prim_opc
  (foreign (include #"caml-bigloo.h"))
  (import
    (__caml_misc #"misc.scm")
    (__caml_opcodes #"opcodes.scm")
    (__caml_prim #"prim.scm"))
  (export
    (opcode_for_primitive_27@prim_opc x1)
    (opcode_for_float_primitive_146@prim_opc x1)))
;; L'initialisation du module                                                
(init_camloo!)
;; Les variables globales                                                    
;; Les expressions globales                                                  
(define opcode_for_primitive_27@prim_opc
  (lambda (x1)
    (labels
      ((:-d.staticfail1001
         ()
         (fatal_error_193@misc #"opcode_for_primitive")))
      (let ((:-d.1002 x1))
        (cond ((eq? :-d.1002 (caml-make-tag 4 38))
               update_132@opcodes)
              ((eq? :-d.1002 (caml-make-tag 11 38))
               raise_41@opcodes)
              ((eq? :-d.1002 (caml-make-tag 12 38))
               boolnot_123@opcodes)
              ((eq? :-d.1002 (caml-make-tag 7 38))
               tagof_105@opcodes)
              ((eq? :-d.1002 (caml-make-tag 13 38))
               negint_130@opcodes)
              ((eq? :-d.1002 (caml-make-tag 14 38))
               succint_67@opcodes)
              ((eq? :-d.1002 (caml-make-tag 15 38))
               predint_236@opcodes)
              ((eq? :-d.1002 (caml-make-tag 16 38))
               addint_163@opcodes)
              ((eq? :-d.1002 (caml-make-tag 17 38))
               subint_74@opcodes)
              ((eq? :-d.1002 (caml-make-tag 18 38))
               mulint_80@opcodes)
              ((eq? :-d.1002 (caml-make-tag 19 38))
               divint_14@opcodes)
              ((eq? :-d.1002 (caml-make-tag 20 38))
               modint_119@opcodes)
              ((eq? :-d.1002 (caml-make-tag 21 38))
               andint_198@opcodes)
              ((eq? :-d.1002 (caml-make-tag 22 38))
               orint_128@opcodes)
              ((eq? :-d.1002 (caml-make-tag 23 38))
               xorint_176@opcodes)
              ((eq? :-d.1002 (caml-make-tag 24 38))
               shiftleftint_166@opcodes)
              ((eq? :-d.1002 (caml-make-tag 25 38))
               shiftrightintsigned_145@opcodes)
              ((eq? :-d.1002 (caml-make-tag 26 38))
               shiftrightintunsigned_75@opcodes)
              ((eq? :-d.1002 (caml-make-tag 27 38))
               incr_93@opcodes)
              ((eq? :-d.1002 (caml-make-tag 28 38))
               decr_38@opcodes)
              ((eq? :-d.1002 (caml-make-tag 29 38))
               intoffloat_123@opcodes)
              ((eq? :-d.1002 (caml-make-tag 31 38))
               stringlength_31@opcodes)
              ((eq? :-d.1002 (caml-make-tag 32 38))
               getstringchar_83@opcodes)
              ((eq? :-d.1002 (caml-make-tag 33 38))
               setstringchar_251@opcodes)
              ((eq? :-d.1002 (caml-make-tag 34 38))
               makevector_165@opcodes)
              ((eq? :-d.1002 (caml-make-tag 35 38))
               vectlength_45@opcodes)
              ((eq? :-d.1002 (caml-make-tag 36 38))
               getvectitem_75@opcodes)
              ((eq? :-d.1002 (caml-make-tag 37 38))
               setvectitem_147@opcodes)
              (else (:-d.staticfail1001)))))))

(define opcode_for_float_primitive_146@prim_opc
  (lambda (x1)
    (let ((:-d.1003 x1))
      (cond ((eq? :-d.1003 (caml-make-tag 0 6))
             floatofint_116@opcodes)
            ((eq? :-d.1003 (caml-make-tag 1 6))
             negfloat_177@opcodes)
            ((eq? :-d.1003 (caml-make-tag 2 6))
             addfloat_221@opcodes)
            ((eq? :-d.1003 (caml-make-tag 3 6))
             subfloat_225@opcodes)
            ((eq? :-d.1003 (caml-make-tag 4 6))
             mulfloat_26@opcodes)
            ((eq? :-d.1003 (caml-make-tag 5 6))
             divfloat_252@opcodes)
            (else #f)))))

(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
