;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.7/Ieee/strings.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul  4 16:03:22 1992                          */
;*    Last change :  Wed Dec 21 08:35:07 1994 (serrano)                */
;*                                                                     */
;*    6.7. Strings (page 25, r4)                                       */
;*---------------------------------------------------------------------*/
   
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_strings_6_7
   (foreign (define bool c-string?       (obj)                "STRINGP")
	    (bstring     c-make-string   (bint bchar)         "make_string")
	    (define bint c-string-length (bstring)            "STRING_LENGTH")
	    (define char c-string-ref    (bstring int)        "STRING_REF")
	    (define obj  c-string-set!   (bstring int char)   "STRING_SET")
	    (bool    c-string=?  (bstring bstring)     "bigloo_strcmp")
	    (bool    strcicmp    (string string)       "strcicmp")
	    (bool    string_lt   (string string)       "string_lt")
	    (bool    string_le   (string string)       "string_le")
	    (bool    string_gt   (string string)       "string_gt")
	    (bool    string_ge   (string string)       "string_ge")
	    (bool    string_cilt (string string)       "string_cilt")
	    (bool    string_cile (string string)       "string_cile")
	    (bool    string_cigt (string string)       "string_cigt")
	    (bool    string_cige (string string)       "string_cige")
	    (bstring c-string-copy (string)            "c_string_to_string")
	    (bstring c-substring (bstring bint bint)   "c_substring")
	    (bstring c-string-append (bstring bstring) "string_append")
	    (bstring escape-C-string (string)          "escape_C_string")
	    (bstring escape-scheme-string (string)     "escape_scheme_string")
	    (bstring c-constant-string-to-string (string)
			    "c_constant_string_to_string")
	    (define bool string-bound-check? (bint bint) "BOUND_CHECK")
	    (bstring c-string-for-read (bstring)         "string_for_read")
	    (obj   c-blit-string (obj obj obj obj obj)   "blit_string"))
   (pragma  (c-string? _dont_return_ 
		       _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-string=? _dont_return_ 
		       _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (strcicmp _dont_return_ 
		       _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (string_lt _dont_return_ 
		       _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (string_le _dont_return_ 
		       _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (string_gt _dont_return_ 
		       _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (string_ge _dont_return_ 
		       _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (string_cilt _dont_return_ 
		       _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (string_cile _dont_return_ 
		       _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (string_cigt _dont_return_ 
		       _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (string_cige _dont_return_ 
		       _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-string-ref  _dont_return_ 
			   _no_side_effect_ _imutable_ _no_mutation_
			   _imbricable_)
	    (c-substring _dont_return_ _no_side_effect_ _imutable_
			 _no_mutation_ _imbricable_))
   (export  (inline string? obj)
	    (inline make-string k . char)
	    (inline string . chars)
	    (inline string-length string)
	    (inline string-ref string k)
	    (inline string-set! string k char)
	    (inline string-ref-ur string k)
	    (inline string-set-ur! string k char)
	    (inline string=? string1 string2)
	    (inline string-ci=? string1 string2)
	    (inline string<? string1 string2)
	    (inline string>? string1 string2)
	    (inline string<=? string1 string2)
	    (inline string>=? string1 string2)
	    (inline string-ci<? string1 string2)
	    (inline string-ci>? string1 string2)
	    (inline string-ci<=? string1 string2)
	    (inline string-ci>=? string1 string2)
	    (inline substring string start end)
	    (inline substring-ur string start end)
	    (string-append . strings)
	    (string->list string)
	    (list->string chars)
	    (inline string-copy string)
	    (string-fill! string char)
	    (string-upcase string)
	    (string-downcase string)
	    (string-upcase! string)
	    (string-downcase! string)
	    (inline string-for-read string)
	    (inline blit-string! s1 o1 s2 o2 l)))

;*---------------------------------------------------------------------*/
;*    string? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (string? obj)
   (c-string? obj))

;*---------------------------------------------------------------------*/
;*    make-string ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline  (make-string k . char)
   (if (null? char)
       (c-make-string k #\space)
       (c-make-string k (car char))))
 
;*---------------------------------------------------------------------*/
;*    string ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (string . chars)
   (list->string chars))

;*---------------------------------------------------------------------*/
;*    string-length ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (string-length string)
   (c-string-length string))

;*---------------------------------------------------------------------*/
;*    string-ref ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (string-ref string k)
   (if (string-bound-check? k (string-length string))
       (c-string-ref string k)
       (error "string-ref" "index out of range" k)))
 
;*---------------------------------------------------------------------*/
;*    string-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-set! string k char)
   (if (string-bound-check? k (string-length string))
       (c-string-set! string k char)
       (error "string-set!" "index out of range" k)))

;*---------------------------------------------------------------------*/
;*    string-ref-ur ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (string-ref-ur string k)
   (c-string-ref string k))
 
;*---------------------------------------------------------------------*/
;*    string-set-ur! ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (string-set-ur! string k char)
   (c-string-set! string k char))

;*---------------------------------------------------------------------*/
;*    string=? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (string=? string1 string2)
   (c-string=? string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci=? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-ci=? string1 string2)
   (strcicmp string1 string2))

;*---------------------------------------------------------------------*/
;*    string<? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (string<? string1 string2)
   (string_lt string1 string2))

;*---------------------------------------------------------------------*/
;*    string>? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (string>? string1 string2)
   (string_gt string1 string2))

;*---------------------------------------------------------------------*/
;*    string<=? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (string<=? string1 string2)
   (string_le string1 string2))

;*---------------------------------------------------------------------*/
;*    string>=? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (string>=? string1 string2)
   (string_ge string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci<? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-ci<? string1 string2)
   (string_cilt string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci>? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-ci>? string1 string2)
   (string_cigt string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci<=? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (string-ci<=? string1 string2)
   (string_cile string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci>=? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (string-ci>=? string1 string2)
   (string_cige string1 string2))

;*---------------------------------------------------------------------*/
;*    sustring ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (substring string start end)
   (if (and (>=fx end start)
	    (string-bound-check? start (+fx (string-length string) 1))
	    (string-bound-check? end (+fx (string-length string) 1)))
       (c-substring string start end)
       (error "substring" "Illegal index" (cons start end))))

;*---------------------------------------------------------------------*/
;*    sustring-ur ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (substring-ur string start end)
   (c-substring string start end))

;*---------------------------------------------------------------------*/
;*    string-append ...                                                */
;*---------------------------------------------------------------------*/
(define (string-append . list)
   (if (null? list)
       ""
       (let loop ((list list))
	  (if (null? (cdr list))
	      (car list)
	      (c-string-append (car list) (loop (cdr list)))))))

;*---------------------------------------------------------------------*/
;*    list->string ...                                                 */
;*---------------------------------------------------------------------*/
(define (list->string list)
   (let* ((len    (length list))
	  (string (make-string len)))
      (let loop ((i 0)
		 (l list))
	 (if (=fx i len)
	     string
	     (begin
		(string-set! string i (car l))
		(loop (+fx i 1) (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    string->list ...                                                 */
;*---------------------------------------------------------------------*/
(define (string->list string)
   (let ((len (string-length string)))
      (let loop ((i   0)
		 (acc '()))
	 (if (=fx i len)
	     (reverse! acc)
	     (loop (+fx i 1)
		   (cons (string-ref string i)
			 acc))))))

;*---------------------------------------------------------------------*/
;*    string-copy ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-copy string)
   (c-string-copy string))

;*---------------------------------------------------------------------*/
;*    string-fill! ...                                                 */
;*---------------------------------------------------------------------*/
(define (string-fill! string char)
   (let ((len (string-length string)))
      (let loop ((i 0))
	 (if (=fx i len)
	     string
	     (begin
		(string-set! string i char)
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    string-upcase ...                                                */
;*---------------------------------------------------------------------*/
(define (string-upcase string)
   (let* ((len (string-length string))
	  (res (make-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(string-set! res i (char-upcase (string-ref string i)))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    string-downcase ...                                              */
;*---------------------------------------------------------------------*/
(define (string-downcase string)
   (let* ((len (string-length string))
	  (res (make-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(string-set! res i (char-downcase (string-ref string i)))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    string-upcase! ...                                               */
;*---------------------------------------------------------------------*/
(define (string-upcase! string)
   (let* ((len (string-length string))
	  (res string))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(string-set! res i (char-upcase (string-ref string i)))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    string-downcase! ...                                             */
;*---------------------------------------------------------------------*/
(define (string-downcase! string)
   (let* ((len (string-length string))
	  (res string))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(string-set! res i (char-downcase (string-ref string i)))
		(loop (+fx i 1)))))))
		 		 
;*---------------------------------------------------------------------*/
;*    string-for-read ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (string-for-read string)
   (c-string-for-read string))

;*---------------------------------------------------------------------*/
;*    blit-string! ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (blit-string! s1 o1 s2 o2 l)
   (c-blit-string s1 o1 s2 o2 l))
