;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.7/Ieee/fixnum.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov 26 14:04:03 1992                          */
;*    Last change :  Fri Jan 13 16:15:45 1995 (serrano)                */
;*                                                                     */
;*    6.5. Numbers (page 18, r4) The `fixnum' functions                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_numbers_6_5_fixnum
   (foreign (define bool c-integer?    (obj)              "INTEGERP")
	    (define bool c-eq.i        (bint bint)        "EQ_I")
	    (define bool c-lt.i        (bint bint)        "LT_I")
	    (define bool c-le.i        (bint bint)        "LE_I")
	    (define bool c-gt.i        (bint bint)        "GT_I")
	    (define bool c-ge.i        (bint bint)        "GE_I")
	    (define bool c-even?       (bint)             "EVENP_I")
	    (define bool c-odd?        (bint)             "ODDP_I")
	    (define bint c-add.i       (bint bint)        "ADD_I")
	    (define bint c-sub.i       (bint bint)        "SUB_I")
	    (define bint c-add-ptag.i  (bint bint)        "ADD_I_PTAG")
	    (define bint c-sub-ptag.i  (bint bint)        "SUB_I_PTAG")
	    (define bint c-psub-tag    (long)             "PSUB_TAG")
	    (define bint c-padd-tag    (long)             "PADD_TAG")
	    (define bint c-mul.i       (bint bint)        "MUL_I")
	    (define bint c-div.i       (bint bint)        "DIV_I")
	    (define bint c-neg.i       (bint)             "NEG_I")
	    (define bint c-abs.i       (bint)             "ABS_I")
	    (define bint c-quotient    (bint bint)        "QUOTIENT_I")
	    (define bint c-remainder   (bint bint)        "REMAINDER_I")
	    (string      c-int->string (long long)        "integer_to_string")
	    (define long strtol        (string long long) "strtol"))
   (export  (inline integer? obj)
	    (inline =fx               n1 n2)
	    (inline >fx               n1 n2)
	    (inline >=fx              n1 n2)
	    (inline <fx               n1 n2)
	    (inline <=fx              n1 n2)
	    (inline zerofx?           n)
	    (inline positivefx?       n)
	    (inline negativefx?       n)
	    (inline odd?              n)
	    (inline even?             n)
	    (maxfx                    n1 . nn)
	    (minfx                    n1 . nn)
	    (inline +fx               z1 z2)
	    (inline -fx               z1 z2)
	    (inline +fx-ptag-left     z1 z2)
	    (inline +fx-ptag-rigth    z1 z2)
	    (inline -fx-ptag-left     z1 z2)
	    (inline -fx-ptag-rigth    z1 z2)
	    (inline *fx               z1 z2)
	    (inline /fx               z1 z2)
	    (inline negfx             n)
	    (inline absfx             n)
	    (inline quotient          n1 n2)
	    (inline remainder         n1 n2)
	    (modulo                   n1 n2)
	    (gcd                      . x)
	    (lcm                      . x)
	    (integer->string          number . radix)
	    (string->integer          string . radix))
   (pragma  (c-integer? _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-eq.i _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-lt.i _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-le.i _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-gt.i _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-ge.i _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-even? _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-odd? _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-add.i _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-sub.i _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-add-ptag.i _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-sub-ptag.i _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-psub-tag _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-padd-tag _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-mul.i _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-div.i _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-neg.i _no_side_effect_ _imbricable_)
	    (c-abs.i _no_side_effect_ _imutable_ _no_mutation_ _imutable_ _no_mutation_ _imbricable_)
	    (c-quotient _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-remainder _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (+fx-ptag-rigth _no_eval_value_)
	    (+fx-ptag-left _no_eval_value_)
	    (-fx-ptag-rigth _no_eval_value_)
	    (-fx-ptag-left _no_eval_value_)))
	    
;*---------------------------------------------------------------------*/
;*    integer? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (integer? obj)
   (c-integer? obj))

;*---------------------------------------------------------------------*/
;*    =fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (=fx n1 n2)
   (c-eq.i n1 n2))

;*---------------------------------------------------------------------*/
;*    <fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (<fx n1 n2)
   (c-lt.i n1 n2))

;*---------------------------------------------------------------------*/
;*    >fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (>fx n1 n2)
   (c-gt.i n1 n2))

;*---------------------------------------------------------------------*/
;*    <=fx ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (<=fx n1 n2)
   (c-le.i n1 n2))

;*---------------------------------------------------------------------*/
;*    >=fx ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (>=fx n1 n2)
   (c-ge.i n1 n2))

;*---------------------------------------------------------------------*/
;*    zerofx? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (zerofx? n)
   (=fx n 0))

;*---------------------------------------------------------------------*/
;*    positivefx?  ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (positivefx? n)
   (>fx n 0))

;*---------------------------------------------------------------------*/
;*    negativefx? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (negativefx? n)
   (<fx n 0))

;*---------------------------------------------------------------------*/
;*    odd? ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (odd? x)
   (c-odd? x))

;*---------------------------------------------------------------------*/
;*    even? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (even? x)
   (c-even? x))

;*---------------------------------------------------------------------*/
;*    maxfx ...                                                        */
;*---------------------------------------------------------------------*/
(define (maxfx n1 . nn)
   (let loop ((max n1)
	      (nn  nn))
      (if (null? nn)
	  max
	  (if (>fx (car nn) max)
	      (loop (car nn) (cdr nn))
	      (loop max (cdr nn))))))
   
;*---------------------------------------------------------------------*/
;*    minfx ...                                                        */
;*---------------------------------------------------------------------*/
(define (minfx n1 . nn)
   (let loop ((min n1)
	      (nn  nn))
      (if (null? nn)
	  min
	  (if (<fx (car nn) min)
	      (loop (car nn) (cdr nn))
	      (loop min (cdr nn))))))
   
;*---------------------------------------------------------------------*/
;*    +fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (+fx z1 z2)
   (c-add.i z1 z2))
	    
;*---------------------------------------------------------------------*/
;*    +fx-ptag-left ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (+fx-ptag-left l r)
   (c-add-ptag.i (c-psub-tag l) r))

;*---------------------------------------------------------------------*/
;*    +fx-ptag-rigth ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (+fx-ptag-rigth l r)
   (c-add-ptag.i l (c-psub-tag r)))

;*---------------------------------------------------------------------*/
;*    -fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (-fx z1 z2)
   (c-sub.i z1 z2))

;*---------------------------------------------------------------------*/
;*    -fx-ptag-left ...                                                */
;*---------------------------------------------------------------------*/
(define-inline  (-fx-ptag-left l r)
   (c-sub-ptag.i (c-padd-tag l) r))

;*---------------------------------------------------------------------*/
;*    -fx-ptag-rigth ...                                               */
;*---------------------------------------------------------------------*/
(define-inline  (-fx-ptag-rigth l r)
   (c-sub-ptag.i l (c-psub-tag r)))

;*---------------------------------------------------------------------*/
;*    *fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (*fx z1 z2)
   (c-mul.i z1 z2))
	    
;*---------------------------------------------------------------------*/
;*    /fx ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (/fx z1 z2)
   (c-div.i z1 z2))
	    
;*---------------------------------------------------------------------*/
;*    negfx ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (negfx n1)
   (c-neg.i n1))

;*---------------------------------------------------------------------*/
;*    absfx ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (absfx n)
   (c-abs.i n))
	    
;*---------------------------------------------------------------------*/
;*    quotient ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (quotient n1 n2)
   (c-quotient n1 n2))

;*---------------------------------------------------------------------*/
;*    remainder ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (remainder n1 n2)
   (c-remainder n1 n2))

;*---------------------------------------------------------------------*/
;*    modulo ...                                                       */
;*---------------------------------------------------------------------*/
(define (modulo x y)
   (let ((r (remainder x y)))
      (if (zerofx? r)
	  r		
	  (if (positivefx? y)
	      (if (positivefx? r) r (+fx y r))
	      (if (negativefx? r) r (+fx y r))))))

;*---------------------------------------------------------------------*/
;*    gcd ...                                                          */
;*---------------------------------------------------------------------*/
(define (gcd . x)
    (define (gcd2 m n)
       (if (zero? n)
	   m
	   (let ((r (remainder m n)))
	      (if (=fx r 0)
		  n
		  (gcd2 n r)))))
    (case (length x)
       ((0) 0)
       ((1) (absfx (car x)))
       (else (let loop ((result (gcd2 (absfx (car x)) (absfx (cadr x))))
			(left (cddr x)))
		(if (pair? left)
		    (loop (gcd2 result (absfx (car left))) (cdr left))
		    result)))))

;*---------------------------------------------------------------------*/
;*    lcm ...                                                          */
;*---------------------------------------------------------------------*/
(define (lcm . x)
   (define (lcm2 m n)
      (let ((m (absfx m)) (n (absfx n)))
	 (cond ((=fx m n) m)
	       ((=fx (remainder m n) 0) m)
	       ((=fx (remainder n m) 0) n)
	       (else (*fx (/fx m (gcd m n)) n)))))
   (case (length x)
      ((0) 1)
      ((1) (absfx (car x)))
      (else (let loop ((result (lcm2 (car x) (cadr x))) (left (cddr x)))
	       (if (pair? left)
		   (loop (lcm2 result (car left)) (cdr left))
		   result)))))

;*---------------------------------------------------------------------*/
;*    integer->string ...                                              */
;*---------------------------------------------------------------------*/
(define (integer->string x . radix)
   (if (null? radix)
       (set! radix 10)
       (set! radix (car radix)))
   (case radix
      ((2 8 10 16)
       (c-int->string x radix))
      (else
       (error "integer->string" "Illegal radix" radix))))
   
;*---------------------------------------------------------------------*/
;*    string->integer ...                                              */
;*---------------------------------------------------------------------*/
(define (string->integer string . radix)
   (if (null? radix)
       (set! radix 10)
       (set! radix (car radix)))
   (strtol string 0 radix))

