;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Tailrec/exp.scm ...      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 30 10:45:15 1994                          */
;*    Last change :  Mon Dec 12 10:35:00 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On tailrecursive une expression                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module tailrec_exp
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "Tailrec/rec-info.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    tailrec_tail)
   (export  (tailrec-expression <exp>)
	    (tailrec-definition <function> <formals> <exp>)))

;*---------------------------------------------------------------------*/
;*    tailrec-definition ...                                           */
;*    -------------------------------------------------------------    */
;*    On ne traite que les fonctions d'arite positive.                 */
;*---------------------------------------------------------------------*/
(define (tailrec-definition who formals exp)
   (trace (tailrec loop) "definition[" (shape who) "]: " (shape exp) #\Newline)
   (if (not (>fx (function-arity (if (local? who)
				     (local-value who)
				     (global-value who)))
		 0))
       exp
       (let* ((rec  (rec-type who formals exp))
	      (type (if (rec-info? rec)
			(rec-info-type rec)
			#f)))
	  (case type
	     ((rec-cons)
	      (trace (tailrec loop) "rec-type: rec-cons" #\Newline)
	      (cons-rec->tail-cons-rec rec))
	     ((rec-+ rec--)
	      (trace (tailrec loop) "rec-type: rec-+-" #\Newline)
	      exp)
	     (else
	      (trace (tailrec loop) "rec-type: unknown" #\Newline)
	      exp)))))

;*---------------------------------------------------------------------*/
;*    tailrec-expression ...                                           */
;*---------------------------------------------------------------------*/
(define (tailrec-expression exp)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?atom)
       exp)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       exp)
;*--- pragma ----------------------------------------------------------*/
      ((pragma (? string?))
       exp)
;*--- assert ----------------------------------------------------------*/
      ((assert ?- ?- ?formals ?body)
       (let loop ((formals formals))
	  (if (null? formals)
	      'done
	      (begin
		 (set-car! formals (tailrec-expression (car formals)))
		 (loop (cdr formals))))
	  (set-car! (cddddr exp) (tailrec-expression body))
	  exp))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (set-cdr! exp (tailrec-expression* body))
       exp)
;*--- set! ------------------------------------------------------------*/
      ((set! ?var ?val)
       (set-car! (cdr exp) (tailrec-expression var))
       (set-car! (cddr exp) (tailrec-expression val))
       exp)
;*--- let -------------------------------------------------------------*/
      ((let ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (tailrec-expression body))
		 exp)
	      (let ((binding (car hook)))
		 (set-car! (cdr binding) (tailrec-expression (cadr binding)))
		 (loop (cdr hook))))))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (tailrec-expression body))
		 exp)
	      (let ((binding (car hook)))
		 (set-car! (cddr binding) (tailrec-expression (caddr binding)))
		 (set-car! (cddr binding) (tailrec-definition (car binding)
							      (cadr binding)
							      (caddr binding)))
		 (loop (cdr hook))))))
;*--- failure ---------------------------------------------------------*/
      ((failure ?proc ?msg ?obj)
       (set-car! (cdr exp) (tailrec-expression proc))
       (set-car! (cddr exp) (tailrec-expression msg))
       (set-car! (cdddr exp) (tailrec-expression obj))
       exp)
;*--- bind-exit -------------------------------------------------------*/
      ((bind-exit (?a) ?body)
       (set-car! (cddr exp) (tailrec-expression body))
       exp)
;*--- apply -----------------------------------------------------------*/
      ((apply ?proc ?arg)
       (set-car! (cdr exp) (tailrec-expression proc))
       (set-car! (cddr exp) (tailrec-expression arg))
       exp)
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (tailrec-expression test))
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! (cdr (car hook))
			   (tailrec-expression (cadr (car hook))))
		 (loop (cdr hook))))))
;*--- if --------------------------------------------------------------*/
      ((if ?si ?alors ?sinon)
       (set-car! (cdr exp) (tailrec-expression si))
       (set-car! (cddr exp) (tailrec-expression alors))
       (set-car! (cdddr exp) (tailrec-expression sinon))
       exp)
;*--- application -----------------------------------------------------*/
      (else
       (tailrec-expression* exp))))

;*---------------------------------------------------------------------*/
;*    tailrec-expression* ...                                          */
;*---------------------------------------------------------------------*/
(define (tailrec-expression* exp)
   (let loop ((hook exp))
      (cond
	 ((null? hook)
	  exp)
	 ((not (pair? hook))
	  exp)
	 (else
	  (set-car! hook (tailrec-expression (car hook)))
	  (loop (cdr hook))))))
   
