;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../property.scm ...                                             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jun 19 08:37:28 1994                          */
;*    Last change :  Sun Jun 19 09:28:58 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Ce module implement la fonction `mark-property!' qui parcours    */
;*    une expression et marque pour chacune des variables locales les  */
;*    infos suivantes:                                                 */
;*       - la variable est-elle retournee ?                            */
;*       - la variable est-elle capturee ?                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module stack_property
   (include "Stack/property.sch")
   )

;*---------------------------------------------------------------------*/
;*    mark-property! ...                                               */
;*    -------------------------------------------------------------    */
;*    On marque les proprietes pour toutes les variables locales.      */
;*---------------------------------------------------------------------*/
(define (mark-property! exp depth)
   (if (not (pair? exp))
       (if (local? exp)
	   (mark-returned! exp)
	   'done)
       (case (car exp)
	  ((quote)
	   'done)
	  ((set! ?var ?val)
	   ;; on parcours recursivement 
	   (mark-property! val)
	   (let ((returned (local-returned val)))
	      (if (local? var)
		  (begin
		     (for-each (lambda (loc) (mark-related! loc var))
			       returned)
		     (for-each (lambda (loc)
				  (if (<fx (s-property-depth (local-info var))
					   (s-property-depth (local-info loc)))
				      (mark-local-captured! loc)))
			       returned))
		  (begin
		     (for-each (lambda (loc)
				  (mark-local-captured! loc))
			       returned)
		     (for-each (lambda (loc)
				  (mark-local-returned! loc))
			       returned)))))
	  

;*---------------------------------------------------------------------*/
;*    mark-related! ...                                                */
;*---------------------------------------------------------------------*/
(define (mark-related! qui a-qui)
   (let ((a-qui-prop (local-info a-qui)))
      (if (not (memq qui (s-property-related a-qui-prop)))
	  (s-property-related-set! a-qui-prop
				   (cons qui
					 (s-property-related a-qui-prop))))))

	    
;*---------------------------------------------------------------------*/
;*    mark-local-captured! ...                                         */
;*    -------------------------------------------------------------    */
;*    On marque qu'une locale est capturee                             */
;*---------------------------------------------------------------------*/
(define (mark-local-captured! local)
   (let ((prop (local-info local)))
      (trace stack
	     "==> captured( " (shape local) " )  [ "
	     (shape (s-property-related prop))
	     "]" #\Newline)
      (if (s-property-captured? prop)
	  'done
	  (begin
	     (s-property-captured?-set! prop #t)
	     (for-each mark-local-captured! (s-property-related prop))))))

;*---------------------------------------------------------------------*/
;*    mark-local-returned! ...                                         */
;*    -------------------------------------------------------------    */
;*    On marque qu'une locale est capturee                             */
;*---------------------------------------------------------------------*/
(define (mark-local-returned! local)
   (trace stack "==> returned( " (shape local) " )" #\Newline)
   (let ((prop (local-info local)))
      (s-property-returned?-set! prop #t)))
