;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Stack/alloc.scm ...      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Jun 19 10:09:21 1994                          */
;*    Last change :  Mon Jul  4 09:57:26 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Le module contenant les manipulations des allocations            */
;*    elles-memes.                                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module stack_alloc
   (include "Var/variable.sch"
	    "Stack/property.sch")
   (import  foreign_tools
	    heap_abstract
	    tools_shape
	    engine_param)
   (export  (heap-allocation? exp)
	    (heap->stack!     local exp)
	    (stack-reference  local)))

;*---------------------------------------------------------------------*/
;*    allocater-size-slot ...                                          */
;*---------------------------------------------------------------------*/
(define (allocater-size-slot alloc-info)
   (vector-ref alloc-info 3))

;*---------------------------------------------------------------------*/
;*    alloc-size ...                                                   */
;*---------------------------------------------------------------------*/
(define (alloc-size exp alloc-info)
   (let* ((slot (allocater-size-slot alloc-info))
	  (arg  (list-ref (cdr exp) slot)))
      (match-case arg
	 ((?fun ?arg)
	  (if (abstract-cint->bint? fun)
	      arg
	      #f))
	 (else
	  (if (integer? arg)
	      arg
	      #f)))))

;*---------------------------------------------------------------------*/
;*    heap-allocation? ...                                             */
;*    -------------------------------------------------------------    */
;*    Est-ce qu'une expression est un appel a un allocateur constant ? */
;*---------------------------------------------------------------------*/
(define (heap-allocation? exp)
   (cond
      ((not (pair? exp))
       ;; ce n'est pas un allocateur
       #f)
      ((or (not (global? (car exp)))
	   (not (eq? (global-class (car exp)) 'foreign)))
       ;; ce n'est pas un allocateur
       #f)
      (else
       ;; c'est un allocateur
       (let ((cell (memq '_allocater_ (global-pragma (car exp)))))
	  (cond
	     ((not (pair? cell))
	      #f)
	     ((or (not (pair? (cdr cell)))
		  (not (vector? (cadr cell)))
		  (not (=fx (vector-length (cadr cell)) 4)))
	      (error "heap-allocation?"
		     "Illegal pragma"
		     (global-pragma (car exp))))
	     (else
	      (let ((alloc-info (cadr cell)))
		 (cond
		    ((eq? (vector-ref alloc-info 3) 'fixed-length)
		     ;; ok, c'est un allocateur constant
		     #t)
		    (else
		     ;; ce n'est pas un allocateur constant, on regarde
		     ;; alors si le premier argument est un nombre.
		     (let ((alloc-size (alloc-size exp alloc-info)))
			(and (integer? alloc-size)
			     (<fx alloc-size
				  *max-stack-allocation-size*))))))))))))

;*---------------------------------------------------------------------*/
;*    heap->stack! ...                                                 */
;*    -------------------------------------------------------------    */
;*    On remplace une allocation dans le tas par une allocation        */
;*    en pile                                                          */
;*    -------------------------------------------------------------    */
;*    On n'a pas besoin de changer le type de la variable car lors de  */
;*    la production de code C, on calcule le type des variables        */
;*    locales. La seule chose importante est donc que les              */
;*    initialiseurs retournent les bons types (a savoir les types en   */
;*    pile).                                                           */
;*---------------------------------------------------------------------*/
(define (heap->stack! local exp)
   (let* ((fun             (car exp))
	  (allocater-prop  (cadr (memq '_allocater_ (global-pragma fun))))
	  (stack-init      (car (abstract (vector-ref allocater-prop 0))))
	  (stack-type-name (vector-ref allocater-prop 1))
	  (reference       (car (abstract (vector-ref allocater-prop 2)))))
      (if (eq? (vector-ref allocater-prop 3) 'fixed-length)
	  (heap->stack-fixed-length! local
				     exp
				     reference
				     stack-init
				     stack-type-name)
	  (heap->stack-variable-length! local
					exp
					reference
					stack-init
					stack-type-name
					(alloc-size exp allocater-prop)))))

;*---------------------------------------------------------------------*/
;*    heap->stack-fixed-length! ...                                    */
;*    -------------------------------------------------------------    */
;*    C'est encore un peu `hacky' mais certain constructeur (comme les */
;*    ML `caml-make-regular' par exemple) on un type bizarre que le    */
;*    compile ne connait pas. Pour resoudre ce pbm dans les pragma je  */
;*    permet de mettre des noms de type (des strings) au lieu des      */
;*    identificateurs de type (les symboles). Il faut donc ici         */
;*    retablir la verite ...                                           */
;*---------------------------------------------------------------------*/
(define (heap->stack-fixed-length! local exp reference stack-init type)
   (s-property-reference-set!    (local-info local) reference)
   (s-property-stack-alloc?-set! (local-info local) #t)
   (if (symbol? type)
       (begin
	  (set-car! exp stack-init)
	  (set-cdr! exp (cons local (cdr exp))))
       (let* ((scheme-type-name (string->symbol type))
	      (c-type-name      type)
	      (scheme-type      (if (type-exists? scheme-type-name)
				    (get-type scheme-type-name)
				    (define-type scheme-type-name
				       c-type-name
				       'stack-type
				       scheme-type-name))))
	  (set-car! exp 'cast)
	  (set-cdr! exp `(,scheme-type (,stack-init ,local ,@(cdr exp)))))))

;*---------------------------------------------------------------------*/
;*    heap->stack-variable-length! ...                                 */
;*    -------------------------------------------------------------    */
;*    Il s'agit d'un type de taille variable, il faut donc construire  */
;*    le nom du type en fonction du nombre d'element qu'on souhaite    */
;*    avoir. C'est relativement `hacky' surtout qu'on construit le nom */
;*    du type C a partir du nom du type Scheme qu'on a trouve dans le  */
;*    pragma !                                                         */
;*---------------------------------------------------------------------*/
(define (heap->stack-variable-length! local exp reference stack-init base-type
				      allocation-size)
   (let* ((c-type-name       (string-append base-type "_t( "
					    (number->string allocation-size)
					    " )"))
	  (scheme-type-name  (string->symbol c-type-name))
	  (scheme-type       (if (type-exists? scheme-type-name)
				 (get-type scheme-type-name)
				 (define-type scheme-type-name
				    c-type-name
				    'stack-type
				    scheme-type-name))))
      (s-property-reference-set!    (local-info local) reference)
      (s-property-stack-alloc?-set! (local-info local) #t)
      (set-car! exp 'cast)
      (set-cdr! exp `(,scheme-type (,stack-init ,local ,@(cdr exp))))))

;*---------------------------------------------------------------------*/
;*    stack-reference ...                                              */
;*    -------------------------------------------------------------    */
;*    On retourne une reference d'un objet alloue en pile.             */
;*---------------------------------------------------------------------*/
(define (stack-reference local)
   (cons (s-property-reference (local-info local))
	 (cons local '())))






