;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/bigloo1.7/comptime1.7/Scan/bind.scm ...                  */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 22 15:54:59 1993                          */
;*    Last change :  Tue Aug  9 09:25:09 1994 (serrano)                */
;*                                                                     */
;*    La construction d'une forme `bind-exit'                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_bind-exit
   (include "Var/variable.sch")
   (import  scan_lexical
	    scan_tree)
   (export  (make-bind-exit-tree form site env)))

;*---------------------------------------------------------------------*/
;*    make-bind-exit-tree ...                                          */
;*---------------------------------------------------------------------*/
(define (make-bind-exit-tree form site env)
   (let* ((local (allocate-local-return (car (cadr form)))))
      (set-car! (cddr form) (make-expression-tree (caddr form)
						  site
						  (cons (cons (car (cadr form))
							      local)
							env)
						  '()))
      (set-car! (cadr form) local)
      form))

