;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../initial.scm ...                                              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 13:27:12 1994                          */
;*    Last change :  Thu Dec 29 07:49:11 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les expanseurs initiaux                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_install
   (import expand_if
	   expand_lambda
	   expand_define
	   expand_expander
	   expand_garithmetique
	   expand_iarithmetique
	   expand_let
	   expand_case
	   expand_struct
	   expand_map
	   expand_assert
	   tools_progn
	   engine_param
	   tools_error
	   var_env)
   (export (install-initial-expander)))

;*---------------------------------------------------------------------*/
;*    install-initial-expander ...                                     */
;*---------------------------------------------------------------------*/
(define (install-initial-expander)

   ;; if
   (install-compiler-expander 'if expand-if)
   
   ;; lambda
   (install-compiler-expander 'lambda expand-lambda)
   
   ;; define
   (install-compiler-expander 'define expand-define)
   
   ;; define-inline
   (install-compiler-expander 'define-inline expand-inline)
   
   ;; define-struct
   (install-compiler-expander 'define-struct expand-struct)
   
   ;; set!
   (install-compiler-expander 'set! expand-set!)
   
   ;; append
   (install-O-comptime-expander 'append
				(lambda (x e)
				   (match-case x
				      ((?- ?l1 ?l2)
				       `(append-2 ,(e l1 e) ,(e l2 e)))
				      ((?- . ?lists)
				       `(append
					 ,@(map (lambda (l) (e l e)) lists)))
				      (else
				       (error "append"
					      "Illegal `append' form"
					      x)))))
   
   ;; string-append
   (install-O-comptime-expander 'string-append
				(lambda (x e)
				   (match-case x
				      ((?- ?s1 ?s2)
				       `(c-string-append ,(e s1 e)
							 ,(e s2 e)))
				      ((?- . ?lists)
				       `(string-append
					 ,@(map (lambda (l) (e l e)) lists)))
				      (else
				       (error "string-append"
					      "Illegal 'string-append' form"
					      x)))))
   
   ;; cons
   (install-O-comptime-expander 'cons
				(lambda (x e)
				   (match-case x
				      ((?fun ?a ?d)
				       (if *optim-cons*
					   (begin
					      (set-car! x 'c-inline-cons)
					      (e x e))
					   `(cons ,(e a e) ,(e d e))))
				      (else
				       (error "cons"
					      "Illegal `cons' form"
					      x)))))
   
   ;; map
   (install-O-comptime-expander 'map expand-map)
   
   ;; for-each
   (install-O-comptime-expander 'for-each expand-for-each)
   
   ;; equal?
   (install-O-comptime-expander 'equal? (lambda (x e)
					   (match-case x
					      ((?- ?a1 ?a2)
					       `(,(if (or (integer? a1)
							  (integer? a2)
							  (and (pair? a1)
							       (eq? (car a1)
								    'quote)
							       (symbol?
								(cadr a1)))
							  (and (pair? a2)
							       (eq? (car a2)
								    'quote)
							       (symbol?
								(cadr a2))))
						      'eq?
						      'equal?)
						 ,(e a1 e)
						 ,(e a2 e)))
					      (else
					       (error "equal?"
						      "Illegal `equal?' form"
						      x)))))
   
   ;; les procedures arithmetiques
   (if *genericity*
       (begin
	  ;; +
	  (install-O-comptime-expander '+ expand-g+)
	  ;; *
	  (install-O-comptime-expander '* expand-g*)
	  ;; /
	  (install-O-comptime-expander '/ expand-g/)
	  ;; -
	  (install-O-comptime-expander '- expand-g-)
	  ;; =
	  (install-O-comptime-expander '= expand-g=)
	  ;; <
	  (install-O-comptime-expander '< expand-g<)
	  ;; >
	  (install-O-comptime-expander '> expand-g>)
	  ;; <=
	  (install-O-comptime-expander '<= expand-g<=)
	  ;; >=
	  (install-O-comptime-expander '>= expand-g>=))
       (begin
	  ;; +
	  (install-O-comptime-expander '+ expand-i+)
	  ;; *
	  (install-O-comptime-expander '* expand-i*)
	  ;; /
	  (install-O-comptime-expander '/ expand-i/)
	  ;; -
	  (install-O-comptime-expander '- expand-i-)
	  ;; =
	  (install-O-comptime-expander '= expand-i=)
	  ;; <
	  (install-O-comptime-expander '< expand-i<)
	  ;; >
	  (install-O-comptime-expander '> expand-i>)
	  ;; <=
	  (install-O-comptime-expander '<= expand-i<=)
	  ;; >=
	  (install-O-comptime-expander '>= expand-i>=)))
   
   ;; +fx
   (install-O-comptime-expander '+fx expand-+fx)
   
   ;; -fx
   (install-O-comptime-expander '-fx expand--fx)
   
   ;; let*
   (install-compiler-expander 'let* expand-let*)
   
   ;; let
   (install-compiler-expander 'let expand-let)
   
   ;; letrec
   (install-compiler-expander 'letrec expand-letrec)
   
   ;; labels
   (install-compiler-expander 'labels expand-labels)
   
   ;; case
   (install-compiler-expander 'case expand-case)
   
   ;; read
   (install-O-comptime-expander 'read
				(lambda (x e)
				   (match-case x
				      ((?- ?port)
				       `(read ,(e port e)))
				      ((?- ?port ?value)
				       `(read ,(e port e) ,(e value e)))
				      ((?-)
				       `(read (current-input-port)))
				      (else
				       (error "read"
					      "Illegal `read' form"
					      x)))))
   
   ;; read/rp
   (install-O-comptime-expander 'read/rp
				(lambda (x e)
				   (match-case x
				      ((?- ?grammar ?port)
				       (if *unsafe-type*
					   `(read/rp-ut ,(e grammar e)
							,(e port e))
					   `(read/rp ,(e grammar e)
						     ,(e port e))))
				      (else
				       (error "read/rp"
					      "Illegal `read/rp' form"
					      x)))))
   
   ;; vector
   (install-O-comptime-expander 'vector
				(lambda (x e)
				   (let ((args (cdr x)))
				      (e `(let ((v (c-create-vector
						    ,(length args))))
					     ,@(let loop ((i    0)
							  (args args)
							  (res  '()))
						  (if (null? args)
						      res
						      (loop (+fx i 1)
							    (cdr args)
							    (cons
							     `(vector-set!
							       v
							       ,i
							       ,(car args))
							     res))))
					     v)
					 e))))
   
   ;; make-vector
   (install-O-comptime-expander 'make-vector
				(lambda (x e)
				   (match-case x
				      ((?- ?n)
				       `(c-make-vector ,(e n e)
						       ,(e '(unspecified) e)))
				      ((?- ?n ?init)
				       `(c-make-vector ,(e n e)
						       ,(e init e)))
				      (else
				       (map (lambda (x) (e x e)) x)))))
   ;; vector-set!
   (install-O-comptime-expander 'vector-set!
				(lambda (x e)
				   (match-case x
				      ((?- ?vec ?k ?obj)
				       (let ((evec (e vec e))
					     (ek   (e k e))
					     (eobj (e obj e)))
					  (if *unsafe-range*
					      `(vector-set-ur! ,evec ,ek ,eobj)
					      `(vector-set! ,evec ,ek ,eobj))))
				      (else
				       (error "vector-set!"
					      "Illegal `vector-set!' form"
					      x)))))
   
   ;; vector-ref
   (install-O-comptime-expander 'vector-ref
				(lambda (x e)
				   (match-case x
				      ((?- ?vec ?k)
				       (let ((evec (e vec e))
					     (ek   (e k e)))
					  (if *unsafe-range*
					      `(vector-ref-ur ,evec ,ek)
					      `(vector-ref ,evec ,ek))))
				      (else
				       (error "vector-ref"
					      "Illegal `vector-ref' form"
					      x)))))
   
   ;; substring
   (install-O-comptime-expander 'substring
				(lambda (x e)
				   (match-case x
				      ((?- ?s ?min ?max)
				       (let ((s   (e s e))
					     (min (e min e))
					     (max (e max e)))
					  (if *unsafe-range*
					      `(substring-ur ,s ,min ,max)
					      `(substring ,s ,min ,max))))
				      (else
				       (map (lambda (x) (e x e) x))))))
   
   ;; string-set!
   (install-O-comptime-expander 'string-set!
				(lambda (x e)
				   (match-case x
				      ((?- ?vec ?k ?obj)
				       (let ((evec (e vec e))
					     (ek   (e k e))
					     (eobj (e obj e)))
					  (if *unsafe-range*
					      `(string-set-ur! ,evec ,ek ,eobj)
					      `(string-set! ,evec ,ek ,eobj))))
				      (else
				       (error "string-set!"
					      "Illegal `string-set!' form"
					      x)))))
   
   ;; string-ref
   (install-O-comptime-expander 'string-ref
				(lambda (x e)
				   (match-case x
				      ((?- ?vec ?k)
				       (let ((evec (e vec e))
					     (ek   (e k e)))
					  (if *unsafe-range*
					      `(string-ref-ur ,evec ,ek)
					      `(string-ref ,evec ,ek))))
				      (else
				       (error "string-ref"
					      "Illegal `string-ref' form"
					      x)))))
   
   ;; integer->char
   (install-O-comptime-expander 'integer->char
				(lambda (x e)
				   (match-case x
				      ((?- ?n)
				       (if *unsafe-range*
					   `(integer->char-ur ,(e n e))
					   `(integer->char ,(e n e)))))))
   
   ;; apply
   (install-O-comptime-expander 'apply
				(lambda (x e)
				   (match-case x
				      ((?- ?function ?one-arg)
				       `(apply ,(e function e)
					       ,(e one-arg e)))
				      ((?- ?function . ?args)
				       `(apply ,(e function e)
					       ,(e `(cons* ,@args) e)))
				      (else
				       (error "apply"
					      "Illegal `apply' form"
					      x)))))
   
   ;; assert
   (install-compiler-expander 'assert expand-assert))
			 
					
 

