;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.7/Cnst/alloc.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  1 17:56:40 1993                          */
;*    Last change :  Thu Sep  1 08:49:41 1994 (serrano)                */
;*                                                                     */
;*    Le module ou on fait les pre-allocations                         */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cnst_alloc
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  engine_param
	    tools_hash
	    tools_shape
	    tools_strings
	    var_declare
	    heap_abstract
	    cnst_module)
   (export  (init-cnst-alloc)
	    (cnst-alloc-string     string)
	    (cnst-alloc-real       real)
	    (cnst-alloc-symbol     symbol)
	    (cnst-alloc-list       list)
	    (cnst-alloc-procedure  procedure link?)
	    (symbol-initialisation)
	    (pair-initialisation)
	    (procedure-initialisation)))

;*---------------------------------------------------------------------*/
;*    Les structures                                                   */
;*---------------------------------------------------------------------*/
(define-struct string-info    string variable)
(define-struct real-info      real string variable)
(define-struct symbol-info    symbol variable)
(define-struct list-info      list variable)
(define-struct procedure-info proc variable)

;*---------------------------------------------------------------------*/
;*    Les createurs pour ces objets                                    */
;*---------------------------------------------------------------------*/
(define (string-info-create string)
   (let ((new (make-string-info)))
      (string-info-string-set! new string)
      new))

(define (real-info-create string)
   (let ((new (make-real-info)))
      (real-info-string-set! new string)
      new))

(define (symbol-info-create symbol)
   (let ((new (make-symbol-info)))
      (symbol-info-symbol-set! new symbol)
      new))

(define (list-info-create list)
   (let ((new (make-list-info)))
      (list-info-list-set! new list)
      new))

(define (procedure-info-create procedure)
   (let ((new (make-procedure-info)))
      (procedure-info-proc-set! new procedure)
      new))

;*---------------------------------------------------------------------*/
;*    get-variable-name ...                                            */
;*---------------------------------------------------------------------*/
(define get-variable-name 
   (let ((key -1))
      (lambda (class)
	 (set! key (+fx 1 key))
	 (upper-string->symbol (string-append class
					      "_"
					      (integer->string key))))))

;*---------------------------------------------------------------------*/
;*    Le tables pour le hashage                                        */
;*---------------------------------------------------------------------*/
(define *string-env*    '())
(define *real-env*      '())
(define *symbol-env*    '())
(define *list-env*      '())
(define *procedure-env* '())

;*---------------------------------------------------------------------*/
;*    init-cnst-alloc ...                                              */
;*---------------------------------------------------------------------*/
(define (init-cnst-alloc)
   (set! *string-env* (make-hashtable 'string-env
				       'string
				       string-info-create
				       string-info-string
				       (lambda (l) l)))
   (set! *real-env*   (make-hashtable 'real-env
				       'string
				       real-info-create
				       real-info-string
				       (lambda (l) l)))
   (set! *symbol-env* (make-hashtable 'symbol-env
				       'symbol
				       symbol-info-create
				       symbol-info-symbol
				       (lambda (l) l))))
				       
;*---------------------------------------------------------------------*/
;*    cnst-alloc-string ...                                            */
;*    string x { t, f } --> global                                     */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-string string)
   (let ((old (and *shared-data*
		   (find-object string *string-env* 'string-env))))
      (if old
	  (string-info-variable old)
	  (let* ((new (bind-object! string *string-env* 'string-env))
		 (var (declare-global-variable! (get-variable-name
						 (shape-string string))
						*module-name*
						'static)))
	     (global-class-set! var 'string)
	     (global-value-set! var string)
	     (string-info-variable-set! new var)
	     var))))

;*---------------------------------------------------------------------*/
;*    cnst-alloc-real ...                                              */
;*    string x { t, f } --> global                                     */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-real real)
   (let* ((string (real->string real))
	  (old (and *shared-data*
		    (find-object string *real-env* 'real-env))))
      (if old
	  (real-info-variable old)
	  (let* ((new (bind-object! string *real-env* 'real-env))
		 (var (declare-global-variable! (get-variable-name
						 "a_real")
						*module-name*
						'static)))
	     (global-class-set! var 'real)
	     (global-value-set! var real)
	     (real-info-real-set!     new real)
	     (real-info-variable-set! new var)
	     var))))

;*---------------------------------------------------------------------*/
;*    cnst-alloc-symbol ...                                            */
;*    symbol --> global                                                */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-symbol symbol)
   (let ((old (find-object symbol *symbol-env* 'symbol-env)))
      (if old
	  (symbol-info-variable old)
	  (let* ((new (bind-object! symbol *symbol-env* 'symbol-env))
		 (var (declare-global-variable! (get-variable-name
						 (shape-string
						  (symbol->string symbol)))
						*module-name*
						'static)))
	     (symbol-info-variable-set! new var)
	     var))))

;*---------------------------------------------------------------------*/
;*    cnst-alloc-list ...                                              */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-list list)
   (let ((old (and *shared-data*
		   (let loop ((env *list-env*))
		      (cond
			 ((null? env)
			  #f)
			 ((equal? (list-info-list (car env)) list)
			  (car env))
			 (else
			  (loop (cdr env))))))))
      (if old
	  (list-info-variable old)
	  (let* ((new (list-info-create list))
		 (var (declare-global-variable! (get-variable-name "list")
						*module-name*
						'static)))
	     (list-info-variable-set! new var)
	     (set! *list-env* (cons new *list-env*))
	     var))))
						
;*---------------------------------------------------------------------*/
;*    cnst-alloc-procedure ...                                         */
;*---------------------------------------------------------------------*/
(define (cnst-alloc-procedure procedure link?)
   (if link?
       procedure
       (let* ((new (procedure-info-create procedure))
	      (var (declare-global-variable! (get-variable-name "procedure")
					     *module-name*
					     'static)))
	  (procedure-info-variable-set! new var)
	  (set! *procedure-env* (cons new *procedure-env*))
	  var))) 
  
;*---------------------------------------------------------------------*/
;*    symbol-initialisation ...                                        */
;*---------------------------------------------------------------------*/
(define (symbol-initialisation)
   (let* ((res '())
	  (proc (lambda (bucket)
		   (let loop ((bucket bucket)
			      (aux    '()))
		      (if (null? bucket)
			  (set! res (append aux res))
			  (loop (cdr bucket)
				(cons `(set! ,(symbol-info-variable
					       (car bucket))
					     ,(abstract-csymbol->bsymbol
					       (symbol->string
						(symbol-info-symbol
						 (car bucket)))))
				      aux)))))))
      (walk-on-hash-table! proc *symbol-env* 'symbol-env)
      res))

;*---------------------------------------------------------------------*/
;*    pair-initialisation ...                                          */
;*---------------------------------------------------------------------*/
(define (pair-initialisation)
   (let loop ((env *list-env*)
	      (res '()))
      (if (null? env)
	  res
	  (let ((li (car env)))
	     (loop (cdr env)
		   (cons `(set! ,(list-info-variable li) ,(list-info-list li))
			 res))))))

;*---------------------------------------------------------------------*/
;*    procedure-initialisation ...                                     */
;*---------------------------------------------------------------------*/
(define (procedure-initialisation)
   (map (lambda (pi)
	   `(set! ,(procedure-info-variable pi)
		  ,(procedure-info-proc pi)))
	*procedure-env*))

;*---------------------------------------------------------------------*/
;*    shape-string ...                                                 */
;*---------------------------------------------------------------------*/
(define (shape-string string)
   (let ((res (make-string 8))
	 (len (string-length string)))
      (let loop ((i 0))
	 (cond
	    ((=fx i len)
	     (substring res 0 len))
	    ((=fx i 8)
	     res)
	    ((char-alphabetic? (string-ref string i))
	     (string-set! res i (string-ref string i))
	     (loop (+fx i 1)))
	    (else
	     (string-set! res i #\_)
	     (loop (+fx i 1)))))))
	  
	  
   
