;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Beta/vgraph.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Apr 11 10:33:28 1993                          */
;*    Last change :  Tue Sep  6 08:48:07 1994 (serrano)                */
;*                                                                     */
;*    On descend dans une expression pour annoter les variables        */
;*    locales                                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module beta_vgraph
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "Beta/beta.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    effect_property
	    scan_lexical)
   (export (vgraph! exp owner)
	   (vgraph-formals! f)))
 
;*---------------------------------------------------------------------*/
;*    vgraph-formals! ...                                              */
;*---------------------------------------------------------------------*/
(define (vgraph-formals! formals)
   (for-each (lambda (f)
		(local-info-set! f '()))
	     formals))

;*---------------------------------------------------------------------*/
;*    vgraph! ...                                                      */
;*---------------------------------------------------------------------*/
(define (vgraph! exp owner)
   (trace beta "vgraph!: " (shape exp) #\Newline)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       (trace beta "vgraph!atom: " (shape exp) #\Newline)
       (if (and (local? exp)
		(var? (local-info exp)))
	   (begin
	      (if (not (eq? (var-owner (local-info exp)) owner))
		  ;; on ne reduis pas des variables qui apparaissent libres
		  ;; dans des lambdas
		  (var-nb-set! (local-info exp)
			       (+fx 2 (var-nb (local-info exp)))))
	      (var-nb-set! (local-info exp)
			   (+fx 1 (var-nb (local-info exp))))
	      (var-always-set! (local-info exp) #f))))
;*--- function --------------------------------------------------------*/
      (((or function function-extra-light function-light) ?-)
       (vgraph! (cadr exp) owner))
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       'done)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       'done)
;*--- cast ------------------------------------------------------------*/
      ((cast ?- ?exp)
       (vgraph! exp owner))
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       (vgraph*! (cdr exp) owner))
;*--- cif -------------------------------------------------------------*/
      ((cif . ?-)
       (vgraph*! (cdr exp) owner))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (vgraph! test owner)
       (let loop ((hook clauses))
	  (if (null? hook)
	      'done
	      (begin
		 (vgraph! (cadr (car hook)) owner)
		 (loop (cdr hook))))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?-)
       (vgraph*! (cdr exp) owner))
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       (vgraph! (cadr exp) owner)
       (vgraph! (caddr exp) owner))
;*--- let -------------------------------------------------------------*/
      ((let . ?-)
       (vgraph-let! exp owner))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (for-each (lambda (b)
		    (local-info-set! (car b) '())
		    (for-each (lambda (f)
				 (local-info-set! f '()))
			      (cadr b)))
		 bindings)
       (vgraph! body owner)
       (let loop ((hook bindings))
	  (if (null? hook)
	      exp
	      (let ((binding (car hook)))
		 (vgraph! (caddr binding) (car binding))
		 (loop (cdr hook))))))
;*--- block -----------------------------------------------------------*/
      ((block . ?-)
       (vgraph! (caddr exp) owner))
;*--- return-from -----------------------------------------------------*/
      ((return-from . ?-)
       (vgraph! (caddr exp) owner))
;*--- funcall-extra-light ---------------------------------------------*/
      (((or apply
	    funcall
	    funcall-medium
	    funcall-light
	    (funcall-extra-light . ?-)) . ?-)
       (vgraph*! (cdr exp) owner))
;*--- application -----------------------------------------------------*/
      (else
       (vgraph-application! exp owner))))

;*---------------------------------------------------------------------*/
;*    vgraph*! ...                                                     */
;*---------------------------------------------------------------------*/
(define (vgraph*! exp owner)
   (for-each (lambda (exp) (vgraph! exp owner))
	     exp))

;*---------------------------------------------------------------------*/
;*    vgraph-application! ...                                          */
;*    -------------------------------------------------------------    */
;*    Si l'application satisfait les conditions suivantes:             */
;*       - C'est une fonction a 1 argument                             */
;*       - cet argument est une variable locale                        */
;*       - La fonction ne fait pas d'effet de bord                     */
;*    Alors on regarde si la variable n'est pas toujours utilisee      */
;*    qu'en argument de cette fonction.                                */
;*---------------------------------------------------------------------*/
(define (vgraph-application! exp owner)
   (if (and (pair? (cdr exp))
	    (local? (cadr exp))
	    (null? (cddr exp))
	    (global? (car exp))
	    (not (side-effect? exp))
	    (not (mutable? exp)))
       (let ((local (cadr exp)))
	  (if (not (var? (local-info local)))
	      'ok
	      (begin
		 (var-nb-set! (local-info local)
			      (+fx 1 (var-nb (local-info local))))
		 (cond
		    ((null? (var-always (local-info local)))
		     (var-new-always-set! (local-info local)
					  (allocate-local-variable
					   (local-name local)))
		     (var-always-set! (local-info local) (car exp)))
		    ((eq? (var-always (local-info local)) (car exp))
		     'ok)
		    (else
		     (var-always-set! (local-info local) #f))))))
       (vgraph*! (cdr exp) owner)))

;*---------------------------------------------------------------------*/
;*    vgraph-let! ...                                                  */
;*---------------------------------------------------------------------*/
(define (vgraph-let! exp owner)
   (trace beta "vgraph-let!: " (shape exp) #\Newline)
   (for-each (lambda (b)
		(let ((var (make-var)))
		   (var-nb-set!     var 0)
		   (var-owner-set!  var owner)
		   (local-info-set! (car b) var)))
	     (cadr exp))
   (for-each (lambda (b)
		(trace beta "vgraph-let(b): " (shape b) #\Newline)
		(vgraph! (cadr b) owner))
	     (cadr exp))
   (vgraph! (caddr exp) owner))
   

