;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/0cfa/reduce.scm ...      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Sep 24 17:16:57 1993                          */
;*    Last change :  Wed Sep 21 16:24:26 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Ce code se charge de reduire les testes de type. L'amelioration  */
;*    de l'allocation a ete faire dans le fichier `diet.scm'. On ne    */
;*    s'en occupe plus du tout maintenant.                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module 0cfa_reduce
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "0cfa/0cfa.sch"
	    "0cfa/app.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    heap_abstract
	    0cfa_0cfa
	    0cfa_foreign)
   (export  (0cfa-reduce-tree! tree)))

;*---------------------------------------------------------------------*/
;*    0cfa-reduce-tree! ...                                            */
;*---------------------------------------------------------------------*/
(define (0cfa-reduce-tree! tree)
   (for-each
    (lambda (var)
       (trace (loop 0cfa)
	      ":::::::::::::::::::::::::::::::::::::::::::"
	      #\Newline
	      (shape var) #\Newline)
       (let ((fun (global-value var)))
	  (function-body-set! fun (0cfa-reduce! (function-body fun)))))
    tree))

;*---------------------------------------------------------------------*/
;*    0cfa-reduce! ...                                                 */
;*---------------------------------------------------------------------*/
(define (0cfa-reduce! exp)
   (trace (loop 0cfa) "0cfa-reduce!: " (shape exp) #\Newline)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       exp)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       exp)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       exp)
;*--- function --------------------------------------------------------*/
      ((function ?-)
       exp)
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       exp)
;*--- cif -------------------------------------------------------------*/
      ((cif ?si ?alors ?sinon)
       (set-car! (cdr exp) (0cfa-reduce! si))
       (set-car! (cddr exp) (0cfa-reduce! alors))
       (set-car! (cdddr exp) (0cfa-reduce! sinon))
       exp)
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (0cfa-reduce! test))
       (for-each (lambda (clause)
		    (set-car! (cdr clause) (0cfa-reduce! (cadr clause))))
		 clauses)
       exp)
;*--- begin -----------------------------------------------------------*/
      ((begin . ?-)
       (let loop ((hook (cdr exp)))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (0cfa-reduce! (car hook)))
		 (loop (cdr hook))))))
;*--- set! ------------------------------------------------------------*/
      ((set! ?- ?val)
       (set-car! (cddr exp) (0cfa-reduce! val))
       exp)
;*--- let -------------------------------------------------------------*/
      ((let ?bindings ?body)
       (let loop ((bindings bindings))
	  (if (null? bindings)
	      (begin
		 (set-car! (cddr exp) (0cfa-reduce! body))
		 exp)
	      (begin
		 (set-car! (cdr (car bindings))
			   (0cfa-reduce! (cadr (car bindings))))
		 (loop (cdr bindings))))))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (let loop ((bindings bindings))
	  (if (null? bindings)
	      (begin
		 (set-car! (cddr exp) (0cfa-reduce! body))
		 exp)
	      (begin
		 (set-car! (cddr (car bindings))
			   (0cfa-reduce! (caddr (car bindings))))
		 (loop (cdr bindings))))))
;*--- block -----------------------------------------------------------*/
      ((block ?var ?body)
       (set-car! (cddr exp) (0cfa-reduce! body))
       exp)
;*--- return-from -----------------------------------------------------*/
      ((return-from ?app-info ?escape ?value)
       (set-car! (cdddr exp) (0cfa-reduce! value))
       exp)
;*--- apply -----------------------------------------------------------*/
      ((apply ?app-info ?fun . ?args)
       (let loop ((hook args))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (0cfa-reduce! fun))
		 exp)
	      (begin
		 (set-car! hook (0cfa-reduce! (car hook)))
		 (loop (cdr hook))))))
;*--- funcall ---------------------------------------------------------*/
      ((funcall ?app-info ?fun . ?args)
       (let loop ((hook args))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (0cfa-reduce! fun))
		 exp)
	      (begin
		 (set-car! hook (0cfa-reduce! (car hook)))
		 (loop (cdr hook))))))
;*--- application -----------------------------------------------------*/
      ((?fun ?app-info . ?args)
       (0cfa-reduce-app exp fun app-info args))))
       
;*---------------------------------------------------------------------*/
;*    0cfa-reduce-app ...                                              */
;*---------------------------------------------------------------------*/
(define (0cfa-reduce-app exp fun app-info args)
   (trace (loop 0cfa) "==> app: " (shape exp) #\Newline)
   (let loop ((hook args))
      (if (null? hook)
	  (begin
	     (if (type-tester? fun)
		 (pre-evaluate-test exp fun)
		 exp))
	  (begin
	     (set-car! hook (0cfa-reduce! (car hook)))
	     (loop (cdr hook))))))

;*---------------------------------------------------------------------*/
;*    pre-evaluate-test ...                                            */
;*    -------------------------------------------------------------    */
;*    un test est vrai si le resultat l'est pour toutes les            */
;*    approximations.                                                  */
;*---------------------------------------------------------------------*/
(define (pre-evaluate-test exp fun)
   (trace (loop 0cfa) "pre-evaluate-test: " (shape exp) #\Newline)
   (cond
      ((abstract? fun 'procedure-arity)
       (procedures-arity (0cfa-exp! (caddr exp)) exp))
      ((abstract? fun 'procedure-correct-arity?)
       (pre-evaluate-procedure-correct-arity exp))
      ((abstract? fun 'c-procedure?)
       (pre-evaluate-procedure? exp))
      ((abstract? fun 'va-procedure?)
       (pre-evaluate-va-procedure? exp))
      (else
       ;; les testeurs n'attendent tous qu'un seul argument.
       (let ((A* (0cfa-exp! (caddr exp))))
	  (if (or (null? A*)
		  (eq? (car A*) 'bottom)
		  (not (null? (cdr A*))))
	      exp
	      (case (car A*)
		 ((bobj)
		  exp)
		 ((bint)
		  (abstract? fun 'c-integer?))
		 ((breal)
		  (abstract? fun 'c-real?))
		 ((bpair)
		  (abstract? fun 'c-pair?))
		 ((bchar)
		  (abstract? fun 'c-char?))
		 ((bsymbol)
		  (abstract? fun 'c-symbol?))
		 ((bstring)
		  (abstract? fun 'c-string?))
		 ((bvector)
		  (abstract? fun 'c-vector?))
		 ((binput-port)
		  (abstract? fun 'c-input-port?))
		 ((boutput-port)
		  (abstract? fun 'c-output-port?))
		 ((bstruct)
		  (abstract? fun 'c-struct?))
		 ((nil)
		  (abstract? fun 'c-null?))
		 (else
		  (cond
		     ((local? exp)
		      (if (or (eq? (local-class exp) 'function)
			      (eq? (local-class exp) 'return))
			  #f
			  exp))
		     ((pair-approx? (car A*))
		      (abstract? fun 'c-pair?))
		     ((global? exp)
		      (if (or (eq? (global-class exp) 'function)
			      (eq? (global-class exp) 'foreign))
			  #f
			  exp))))))))))
	  
;*---------------------------------------------------------------------*/
;*    type-tester? ...                                                 */
;*---------------------------------------------------------------------*/
(define (type-tester? fun)
   (and (global? fun)
	(eq? (global-import fun) 'foreign)
	(memq fun (abstract-type-tester))))

;*---------------------------------------------------------------------*/
;*    procedures-arity ...                                             */
;*    -------------------------------------------------------------    */
;*    Si toutes les approximations ont la meme arite on la retourne.   */
;*    Sinon on retourne `exp'                                          */
;*---------------------------------------------------------------------*/
(define (procedures-arity A* exp)
   (define (procedure-arity var)
      (cond
	 ((local? var)
	  (cond
	     ((eq? (local-class var) 'function)
	      (function-arity (local-value var)))
	     ((eq? (local-class var) 'return)
	      1)
	     (else
	      #f)))
	 ((global? var)
	  (if (eq? (global-class var) 'function)
	      (function-arity (global-value var))
	      #f))))
   (let ((arity (procedure-arity (car A*))))
      (let loop ((approxs (cdr A*)))
	 (cond
	    ((not (integer? arity))
	     exp)
	    ((null? approxs)
	     arity)
	    ((eq? (procedure-arity (car approxs)) arity)
	     (loop (cdr approxs)))
	    (else
	     exp)))))
		  
;*---------------------------------------------------------------------*/
;*    pre-evaluate-procedure-correct-arity ...                         */
;*---------------------------------------------------------------------*/
(define (pre-evaluate-procedure-correct-arity exp)
   (let ((A*    (0cfa-exp! (caddr exp)))
	 (arity (cadddr exp)))
      (trace (loop 0cfa) "pre-evaluate-procedure-correct-arity: " (shape exp)
	     #\Newline
	     "     A*   : " (shape A*) #\Newline
	     "     arity: " (shape arity) #\Newline)
      (cond
	 ((null? A*)
	  exp)
	 ((not (integer? arity))
	  exp)
	 (else
	  (let loop ((A* A*))
	     (cond
		((null? A*)
		 #t)
		((local? (car A*))
		 (cond
		    ((not (eq? (local-class (car A*)) 'function))
		     exp)
		    ((=fx (function-arity (local-value (car A*))) arity)
		     (loop (cdr A*)))
		    ((and (<fx (function-arity (local-value (car A*))) 0)
			  (<=fx (-fx (negfx
				      (function-arity (local-value (car A*))))
				     -1)
				arity))
		     (loop (cdr A*)))
		    (else
		     exp)))
		((global? (car A*))
		 (cond
		    ((not (eq? (global-class (car A*)) 'function))
		     exp)
		    ((=fx (function-arity (global-value (car A*))) arity)
		     (loop (cdr A*)))
		    ((and (<fx (function-arity (global-value (car A*))) 0)
			  (<=fx (-fx (negfx
				      (function-arity (global-value (car A*))))
				     -1)
				arity))
		     (loop (cdr A*)))
		    (else
		     exp)))
		(else
		 exp)))))))
		 
;*---------------------------------------------------------------------*/
;*    pre-evaluate-procedure? ...                                      */
;*---------------------------------------------------------------------*/
(define (pre-evaluate-procedure? exp)
   (let ((A* (0cfa-exp! (caddr exp))))
      (if (null? A*)
	  exp
	  (let loop ((A* A*))
	     (cond
		((null? A*)
		 #t)
		((local? (car A*))
		 (if (eq? (local-class (car A*)) 'function)
		     (loop (cdr A*))
		     exp))
		((global? (car A*))
		 (if (eq? (global-class (car A*)) 'function)
		     (loop (cdr A*))
		     exp))
		(else
		 exp))))))
      
;*---------------------------------------------------------------------*/
;*       pre-evaluate-procedure? ...                                   */
;*---------------------------------------------------------------------*/
(define (pre-evaluate-va-procedure? exp)
   (let ((A* (0cfa-exp! (caddr exp))))
      (if (null? A*)
	  exp
	  (let loop ((A* A*))
	     (cond
		((null? A*)
		 #t)
		((local? (car A*))
		 (cond
		    ((not (eq? (local-class (car A*)) 'function))
		     exp)
		    ((<fx (function-arity (local-value (car A*))) 0)
		     (loop (cdr A*)))
		    (else
		     exp)))
		((global? (car A*))
		 (cond
		    ((not (eq? (global-class (car A*)) 'function))
		     exp)
		    ((<fx (function-arity (global-value (car A*))) 0)
		     (loop (cdr A*)))
		    (else
		     exp)))
		(else
		 exp))))))
