;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/0cfa/app.scm ...         */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 22 08:25:35 1993                          */
;*    Last change :  Tue Sep  6 18:48:02 1994 (serrano)                */
;*                                                                     */
;*    La gestion de l'application pour la `0cfa'                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module 0cfa_application
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "0cfa/0cfa.sch"
	    "0cfa/app.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    0cfa_0cfa
	    0cfa_foreign
	    engine_param
	    heap_abstract)
   (export  (0cfa-unknown-application! exp app-info fun args-A*)
	    (0cfa-apply app-info exp fun args-A)
	    (0cfa-known-application! exp app-info fun args-A*)
	    (0cfa-function-body! fun value)))

;*---------------------------------------------------------------------*/
;*    0cfa-apply ...                                                   */
;*---------------------------------------------------------------------*/
(define (0cfa-apply exp app-info fun args-A)
   (trace (0cfa loop) "0cfa-apply: " (shape exp) #\Newline)
   (let ((fun-A* (0cfa-exp! fun)))
      ;; opn met a jour le champ `fun' de `app-info'
      (app-fun*-set! app-info fun-A*)
      ;; on met a jour les champs `site*' pour chaque element de `fun-A*'.
      ;; on met a jour le champ `unicity' de toutes les fonctions de `fun-A*'
      (set-site*! fun-A* app-info)
      ;; on met toutes les lambda a `strong'
      (for-each (lambda (f)
		   (cond
		      ((local? f)
		       (if (eq? (local-class f) 'function)
			   (_lambda-strength-set! (local-info f) 'strong)))
		      ((global? f)
		       (if (eq? (global-class f) 'function)
			   (_lambda-strength-set! (global-info f) 'strong)))))
		   
		fun-A*)
      ;; on calcule toutes les approximations possibles
      (let ((args-A* (if (<=fx *optim* 3)
			 '((bottom))
			 (let loop ((args-A args-A)
				    (res    '()))
			    (trace (0cfa loop)
				   "loop: " (shape args-A) #\Newline
				   "loop: " (shape res) #\Newline)
			    (cond
			       ((null? args-A)
				'((bottom)))
			       ((eq? (car args-A) 'nil)
				(reverse! res))
			       ((pair-approx? (car args-A))
				(loop (0cfa-car/cdr cadr args-A)
				      (cons (0cfa-car/cdr car args-A)
					    res)))
			       (else
				'((bottom))))))))
	 (0cfa-unknown-application! exp app-info fun args-A*))))

;*---------------------------------------------------------------------*/
;*    0cfa-unknown-application! ...                                    */
;*---------------------------------------------------------------------*/
(define (0cfa-unknown-application! exp app-info fun args-A*)
   (trace (0cfa loop) "0cfa-unknown-application: " (shape exp)
	  " (" (shape args-A*) ")" #\Newline)
   (let ((fun-A* (0cfa-exp! fun)))
      ;; on met a jour le champ `fun*' de `app-info'
      (app-fun*-set! app-info fun-A*)
      ;; on met a jour les champs `site*' pour chaque element de `fun-A*'.
      ;; on met a jour le champ `unicity' de toutes les fonctions de `fun-A*'
      (set-site*! fun-A* app-info)
      ;; on calcule toutes les approximations possibles
      (let loop ((fA*    fun-A*)
		 (res-A* (app-res* app-info)))
	 (trace (0cfa loop) "0cfa-unknown-application!: " (shape fA*)
		#\Newline)
	 (cond
	    ((null? fA*)
	     (app-args*-set! app-info args-A*)
	     (app-res*-set!  app-info res-A*)
	     res-A*)
	    ((memq (car fA*) (app-fun* app-info))
	     ;; (car fA*) est deja dans la liste, on ne le rajoute pas.
	     (let ((try (0cfa-try-application! exp
					       app-info
					       (car fA*)
					       args-A*)))
		(loop (cdr fA*)
		      (union try res-A*))))
	    (else
	     (app-fun*-set! app-info (cons (car fA*) (app-fun* app-info)))
	     (let ((try (0cfa-try-application! exp
					       app-info
					       (car fA*)
					       args-A*)))
		(loop (cdr fA*)
		      (union try res-A*))))))))

;*---------------------------------------------------------------------*/
;*    0cfa-try-application! ...                                        */
;*---------------------------------------------------------------------*/
(define (0cfa-try-application! exp app-info fun-A args-A*)
   (trace (0cfa loop) "0cfa-try-application!: "
	  (shape fun-A) " " (shape args-A*) #\Newline)
   (cond
      ((local? fun-A)
       (if (eq? (local-class fun-A) 'function)
	   (0cfa-known-application! `(,fun-A ,app-info ,@(cdddr exp))
				    app-info fun-A args-A*)
	   (0cfa-unknown-application! exp app-info fun-A args-A*)))
      ((global? fun-A)
       (if (eq? (global-class fun-A) 'function)
	   (0cfa-known-application! exp app-info fun-A args-A*)
	   (0cfa-unknown-application! `(,fun-A ,app-info ,@(cdddr exp))
				      app-info fun-A args-A*)))
      ((eq? fun-A 'bottom)
       (for-each set-bottom! args-A*)
       '(bottom))
      (else
       (trace 0cfa
	      "!!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!"
	      #\Newline
	      "Probably illegal application of variable `" (shape fun-A) "'"
	      #\Newline)
       (may-error 'type))))
       
;*---------------------------------------------------------------------*/
;*    0cfa-known-application! ...                                      */
;*---------------------------------------------------------------------*/
(define (0cfa-known-application! exp app-info fun args-A*)
   (trace (0cfa loop) "0cfa-known-application!: "
	  (shape fun) " " (shape args-A*) #\Newline)
   (let ((res-A* (cond
		    ((library-function? fun)
		     (library-type fun))
		    ((external-function? fun)
		     (0cfa-bottom-application! exp app-info fun args-A*))
		    ((foreign-function? fun)
		     (0cfa-foreign-application! exp app-info fun args-A*))
		    ((global? fun)
		     (if (>=fx (function-arity (global-value fun)) 0)
			 (0cfa-known-fx-application! exp
						     app-info fun args-A*
						     (global-value fun))
			 (0cfa-known-va-application! exp
						     app-info fun args-A*
						     (global-value fun))))
		    (else
		     (if (>=fx (function-arity (local-value fun)) 0)
			 (0cfa-known-fx-application! exp
						     app-info fun args-A*
						     (local-value fun))
			 (0cfa-known-va-application! exp
						     app-info fun args-A*
						     (local-value fun)))))))
      (app-args*-set! app-info args-A*)
      (app-res*-set!  app-info res-A*)
      res-A*))

;*---------------------------------------------------------------------*/
;*    0cfa-known-fx-application! ...                                   */
;*---------------------------------------------------------------------*/
(define (0cfa-known-fx-application! exp app-info fun args-A* value)
   ;; on test que l'arite est correcte
   (if (not (=fx (length (function-args value)) (length args-A*)))
       (let ((info (if (local? fun) (local-info fun) (global-info fun))))
	  (_lambda-strength-set! info 'strong)
	  (may-error 'arity))
       (begin
	  (for-each (lambda (v a*)
		       (set-formal-approx! v A* fun))
		    (function-args value) args-A*)
	  (0cfa-function-body! fun value))))

;*---------------------------------------------------------------------*/
;*    0cfa-known-va-application! ...                                   */
;*---------------------------------------------------------------------*/
(define (0cfa-known-va-application! exp app-info fun args-A* value)
   ;; on test que l'arite est correcte
   (if (>fx (negfx (+fx (function-arity value) 1))
	    (length args-A*))
       (let ((info (if (local? fun) (local-info fun) (global-info fun))))
	  (_lambda-strength-set! info 'strong)
	  (may-error 'arity))
       (let loop ((formals  (function-args value))
		  (args-A*  args-A*)
		  (arity    (function-arity value)))
	  (if (=fx arity -1)
	      (begin
		 (cond
		    ((<=fx *optim* 3)
		     (set-formal-approx! (car formals) '(bpair nil) fun))
		    ((null? args-A*)
		     (set-formal-approx! (car formals) '(nil) fun))
		    (else
		     (set-formal-approx! (car formals) (car args-A*) fun)))
		 (0cfa-function-body! fun value))
	      (begin
		 (set-formal-approx! (car formals) (car args-A*) fun)
		 (loop (cdr formals)
		       (cdr args-A*)
		       (+fx arity 1)))))))

;*---------------------------------------------------------------------*/
;*    0cfa-bottom-application! ...                                     */
;*---------------------------------------------------------------------*/
(define (0cfa-bottom-application! exp app-info fun args-A*)
   (for-each set-bottom! args-A*)
   '(bottom))

;*---------------------------------------------------------------------*/
;*    library-function? ...                                            */
;*---------------------------------------------------------------------*/
(define (library-function? fun)
   (abstract? fun 'length))

;*---------------------------------------------------------------------*/
;*    library-type ...                                                 */
;*---------------------------------------------------------------------*/
(define (library-type fun)
   (cond
      ((abstract? fun 'length)
       '(bint))
      (else
       '(bottom))))

;*---------------------------------------------------------------------*/
;*    may-error ...                                                    */
;*---------------------------------------------------------------------*/
(define (may-error kind)
   (case kind
      ((arity)
       (if *unsafe-arity*
	   '()
	   '(bottom)))
      ((type)
       (if *unsafe-type*
	   '()
	   '(bottom)))
      (else
       '(bottom))))

;*---------------------------------------------------------------------*/
;*    set-site*! ...                                                   */
;*    -------------------------------------------------------------    */
;*    Des qu'il y a plusieurs fonction possible, on dit que l'ensemble */
;*    entier ne verifie plus le critere d'uncite. Il suffit juste de   */
;*    tester que l'ensemble est de cardinal 1.                         */
;*---------------------------------------------------------------------*/
(define (set-site*! fun-A* app-info)
   (trace (0cfa loop) "set-site*!: " (shape fun-A*) #\Newline)
   (let ((strong? (or (memq 'bottom fun-A*)
		      (and (not *unsafe-type*)
			   (let loop ((fun-A* fun-A*))
			      (cond
				 ((null? fun-A*)
				  #f)
				 ((local? (car fun-A*))
				  (if (eq? (local-class (car fun-A*))
					   'function)
				      (loop (cdr fun-A*))
				      #t))
				 ((global? (car fun-A*))
				  (if (eq? (global-class (car fun-A*))
					   'function)
				      (loop (cdr fun-A*))
				      #t))
				 (else
				  #t)))))))
      (if (null? fun-A*)
	  'done
	  (for-each (lambda (fun-A)
		       (cond
			  ((local? fun-A)
			   (let ((info (local-info fun-A)))
			      (if (not (memq app-info (_lambda-site* info)))
				  (_lambda-site*-set!
				   info
				   (cons app-info (_lambda-site* info))))
			      (cond
				 (strong?
				  (_lambda-strength-set! info 'strong))
				 ((not (eq? (_lambda-strength info)
					    'extra-light))
				  'done)
				 ((not (null? (cdr fun-A*)))
				  (_lambda-strength-set! info 'light))
				 (else
				  'done))))
			  ((global? fun-A)
			   (let ((info (get-global-lambda! fun-A)))
			      (if (not (memq app-info (_lambda-site* info)))
				  (_lambda-site*-set!
				   info
				   (cons app-info (_lambda-site* info))))
			      (cond
				 (strong?
				  (_lambda-strength-set! info 'strong))
				 ((not (eq? (_lambda-strength info)
					    'extra-light))
				  'done)
				 ((not (null? (cdr fun-A*)))
				  (_lambda-strength-set! info 'light))
				 (else
				  'done))))
			  (else
			   'done)))
		    fun-A*))))
   

;*---------------------------------------------------------------------*/
;*    0cfa-function-body! ...                                          */
;*---------------------------------------------------------------------*/
(define (0cfa-function-body! fun value)
   (trace (0cfa loop) "function-body!: " (shape fun) #\Newline)
   (let (info value)
      (if (local? fun)
	  (begin
	     (set! info (local-info fun))
	     (set! value (local-value fun)))
	  (begin
	     (set! info (get-global-lambda! fun))
	     (set! value (global-value fun))))
      (if (eq? (_lambda-stamp info) *time-stamp*)
	  ;; non, ca a deja ete fait
	  (_lambda-body-A* info)
	  ;; oui, il faut evaluer le corps
	  (begin
	     (_lambda-stamp-set! info *time-stamp*)
	     (enter-function (shape fun))
	     (let ((res-A* (0cfa-exp! (function-body value))))
		(leave-function)
		(_lambda-body-A*-set! info res-A*)
		res-A*)))))

;*---------------------------------------------------------------------*/
;*    external-function? ...                                           */
;*---------------------------------------------------------------------*/
(define (external-function? var)
   (and (global? var)
	(eq? (global-import var) 'import)))

;*---------------------------------------------------------------------*/
;*    foreign-function? ...                                            */
;*---------------------------------------------------------------------*/
(define (foreign-function? var)
   (and (global? var)
	(eq? (global-import var) 'foreign)))
 
