;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/work/Pp/Pp/find-rep.scm ...          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 27 11:38:31 1993                          */
;*    Last change :  Mon Dec  6 09:07:56 1993 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On recherche la meilleur representation qui tienne dans une      */
;*    ligne.                                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __pp-find-rep
   (import (*pp-width*    __pp "Pp/pp.scm")
	   (*pp-optimize* __pp "Pp/pp.scm"))
   (export (find-rep rep)))

;*---------------------------------------------------------------------*/
;*    lrep ...                                                         */
;*---------------------------------------------------------------------*/
(define-struct lrep len cursor indent nb-tab exp)

;*---------------------------------------------------------------------*/
;*    create-lrep ...                                                  */
;*---------------------------------------------------------------------*/
(define (create-lrep len cursor indent nb-tab exp)
   (let ((new (make-lrep)))
      (lrep-len-set!    new len)
      (lrep-cursor-set! new cursor)
      (lrep-indent-set! new indent)
      (lrep-nb-tab-set! new nb-tab)
      (lrep-exp-set!    new exp)
      new))

;*---------------------------------------------------------------------*/
;*    lrep-move-cursor! ...                                            */
;*---------------------------------------------------------------------*/
(define (lrep-move-cursor! lrep new-cursor)
   (lrep-cursor-set! lrep new-cursor)
   (if (>fx (lrep-cursor lrep) (lrep-len lrep))
       (lrep-len-set! lrep (lrep-cursor lrep))))

;*---------------------------------------------------------------------*/
;*    get-rep ...                                                      */
;*---------------------------------------------------------------------*/
(define (get-rep rep res)
   (match-case rep
      (()
       res)
      (((? char?) . ?-)
       (let ((r res))
	  (if (char=? (car rep) #\()
	      (lrep-indent-set! r (cons (lrep-cursor r)
					(lrep-indent r))))
	  (if (char=? (car rep) #\))
	      (lrep-indent-set! r (cdr (lrep-indent r))))
	  (lrep-move-cursor! r (+fx 1 (lrep-cursor r)))
	  (lrep-exp-set! r (cons (car rep) (lrep-exp r))))
       (get-rep (cdr rep) res))
      (((char  ?c) . ?-)
       (let ((r res))
	  (lrep-move-cursor! r (+fx 3 (lrep-cursor r)))
	  (lrep-exp-set! r (cons (car rep) (lrep-exp r))))
       (get-rep (cdr rep) res))
      (((? string?) . ?-)
       (let ((r res))
	  (lrep-move-cursor! r (+fx (string-length (car rep))
				    (lrep-cursor r)))
	  (lrep-exp-set! r (cons (car rep) (lrep-exp r))))
       (get-rep (cdr rep) res))
      (((comment ?str) . ?-)
       (let ((r res))
	  (lrep-move-cursor! r (+fx (string-length str)
				    (lrep-cursor r)))
	  (lrep-exp-set! r (cons (car rep) (lrep-exp r))))
       (get-rep (cdr rep) res))
      (((mark-tab) . ?-)
       (let ((r res))
	  (set-car! (lrep-indent r) (lrep-cursor r))
	  (lrep-exp-set! r (cons (car rep) (lrep-exp r))))
       (get-rep (cdr rep) res))
      (((tab ?n) . ?-)
       (let ((r res))
	  (lrep-nb-tab-set! r (+fx 1 (lrep-nb-tab r)))
	  (lrep-move-cursor! r (+fx n (car (lrep-indent r))))
	  (lrep-exp-set! r (cons (car rep) (lrep-exp r))))
       (get-rep (cdr rep) res))
      (((space-cut) . ?-)
       (let ((r res))
	  (if (>=fx (lrep-cursor r) (-fx *pp-width* 2))
	      ;; on fait comme un tab
	      (begin
		 (lrep-nb-tab-set! r (+fx 1 (lrep-nb-tab r)))
		 (lrep-move-cursor! r (+fx 1 (car (lrep-indent r))))
		 (lrep-exp-set! r (cons '(tab 1) (lrep-exp r))))
	      ;; on fait comme un char
	      (begin
		 (lrep-move-cursor! r (+fx 1 (lrep-cursor r)))
		 (lrep-exp-set! r (cons #\space (lrep-exp r))))))
       (get-rep (cdr rep) res))
      ((((kwote or) . ?-) . ?-)
       (get-or rep res))
      (((? pair?) . ?-)
       (if (<fx *pp-optimize* 2)
	   (get-rep (cdr rep) (get-rep (car rep) res))
	   (get-rep (append (car rep) (cdr rep)) res)))
      (else
       (error "get-rep" "Illegal form" rep))))

;*---------------------------------------------------------------------*/
;*    get-or ...                                                       */
;*---------------------------------------------------------------------*/
(define (get-or rep res)
   (match-case rep
      ((((kwote or) . ?exps) . ?-)
       (let* ((old-res (create-lrep (lrep-len res)
				    (lrep-cursor res)
				    (reverse! (reverse
					       (lrep-indent res)))
				    (lrep-nb-tab res)
				    (lrep-exp res)))
	      (first  (get-rep (cons (car exps) (cdr rep)) old-res)))
	  (let loop ((old-res (create-lrep (lrep-len res)
					   (lrep-cursor res)
					   (reverse! (reverse
						      (lrep-indent res)))
					   (lrep-nb-tab res)
					   (lrep-exp res)))
		     (exps    (cdr exps))
		     (min-tab (lrep-nb-tab first))
		     (max-len (lrep-len first))
		     (max-res first))
	     (cond
		((null? exps)
		 max-res)
		(else
		 (let* ((try     (get-rep (cons (car exps)
						(cdr rep)) old-res))
			(try-len (lrep-len try))
			(try-tab (lrep-nb-tab try))
			(old-res (create-lrep (lrep-len res)
					      (lrep-cursor res)
					      (reverse! (reverse
							 (lrep-indent res)))
					      (lrep-nb-tab res)
					      (lrep-exp res))))
		    (cond
		       ((>fx try-len *pp-width*)
			(if (or (<fx try-len max-len)
				(and (=fx try-len max-len)
				     (<fx try-tab min-tab)))
			    (loop old-res
				  (cdr exps)
				  try-tab
				  try-len
				  try)
			    (loop old-res
				  (cdr exps)
				  min-tab
				  max-len
				  max-res)))
		       ((or (>fx try-len max-len)
			    (>fx max-len *pp-width*))
			(loop old-res
			      (if (>fx *pp-optimize* 0)
				  '()
				  (cdr exps))
			      try-tab
			      try-len
			      try))
		       ((<fx try-tab min-tab)
			(loop old-res
			      (cdr exps)
			      try-tab
			      try-len
			      try))
		       (else
			(loop old-res
			      (cdr exps)
			      min-tab
			      max-len
			      max-res)))))))))))

;*---------------------------------------------------------------------*/
;*    find-rep ...                                                     */
;*---------------------------------------------------------------------*/
(define (find-rep rep)
   (lrep-exp (get-rep rep (create-lrep 0 0 '(0) 0 '()))))
      

