;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.5/Scan/eval.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Apr 13 09:09:26 1993                          */
;*    Last change :  Wed Nov  3 10:31:11 1993 (serrano)                */
;*                                                                     */
;*    L'initialisation nessecaire a `eval'                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module scan_eval
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  engine_param
	    tools_hash
	    tools_shape
	    tools_module
	    tools_error
	    heap_abstract
	    var_env)
   (export  (eval-initialisation)))

;*---------------------------------------------------------------------*/
;*    eval-initialisation ...                                          */
;*---------------------------------------------------------------------*/
(define (eval-initialisation)
   (trace init "eval-initialisation: " *eval?*)
   (if (not *eval?*)
       '()
       (let* ((res  '())
	      (proc (lambda (bucket)
		       (let loop ((bucket bucket)
				  (aux    '()))
			  (if (null? bucket)
			      (set! res (append aux res))
			      (let ((obj (car bucket)))
				 (cond
				    ((and (not (eq? (global-class obj)
						    'foreign))
					  (or (null? (global-library? obj))
					      *lib-mode*)
					  (not (eq? (global-import obj)
						    'top-level)))
				     (loop (cdr bucket)
					   (cons
					    (if (eq? (global-class obj)
						     'variable)
						(abstract-define-primop-ref
						 (abstract-string->symbol
						  (symbol->string
						   (global-name obj)))
						 (abstract-location obj))
						(abstract-define-primop
						 (abstract-string->symbol
						  (symbol->string
						   (global-name obj)))
						 obj))
					    aux)))
				    (else
				     (loop (cdr bucket) aux)))))))))
	  (walk-on-hash-table! proc *Genv* 'genv)
	  (cons (abstract-init-the-global-env) res))))
			     
		  
       
