;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../expd-case.scm ...                                            */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul  3 10:13:16 1992                          */
;*    Last change :  Wed Apr 28 11:30:08 1993  (serrano)               */
;*                                                                     */
;*    On macro-expanse ce satane-case                                  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_case
   (import (__expander "Llib/expander.scm"))
   (export (expand-eval-case x e)))
	   
;*---------------------------------------------------------------------*/
;*    expand-eval-case ...                                             */
;*---------------------------------------------------------------------*/
(define (expand-eval-case x e)
   (match-case x
      ((?- ?value . ?clauses)
       (generic-case value clauses e))
      (else
       (error "case" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    generic-case ...                                                 */
;*    sexp x < datum+ x sexp+ >+ x (sexp x sexp --> sexp)              */  
;*---------------------------------------------------------------------*/
(define (generic-case value clauses e)
   (e `(let ((case-value ,value))
	  ,(let loop ((clauses clauses))
	      (if (null? clauses)
		  #f
		  (match-case (car clauses)
		     (()
		      #f)
		     ((else . ?body)
		      (normalize-progn body))
		     (((and ?datums (?- . (?- ???-))) . ?body)
		      `(if (memq case-value ',datums)
			   ,(normalize-progn body)
			   ,(loop (cdr clauses))))
		     (((?datums) . ?body)
		      `(if (eq? case-value ',datums)
			   ,(normalize-progn body)
			   ,(loop (cdr clauses))))))))
      e))



	  
