;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Ieee/reader.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 22 15:23:18 1992                          */
;*    Last change :  Mon May 16 16:53:25 1994 (serrano)                */
;*                                                                     */
;*    Le reader de `Bigloo'                                            */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __reader
   (foreign (define obj vector-tag-set! (bvector bobj) "VECTOR_TAG_SET")
	    (define obj beof "BEOF")
	    (define obj make-cnst (long) "BCNST"))
   (export  *bigloo-interpreter*
	    read
	    read-of-strings
	    (reader-reset!)))

;*---------------------------------------------------------------------*/
;*    *bigloo-interpreter* ...                                         */
;*---------------------------------------------------------------------*/
(define *bigloo-interpreter* #f)

;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define read-of-strings
   (let ((grammar (regular-grammar ()
		     ((+ (in #\space #\tab #\newline))
		      (ignore))
		     ((+ (out #\space #\tab #\newline))
		      (the-string)))))
      (lambda input-port
	 (if (null? input-port)
	     (read/rp grammar (current-input-port))
	     (read/rp grammar (car input-port))))))

;*---------------------------------------------------------------------*/
;*    Les variables de control du lecteur                              */
;*---------------------------------------------------------------------*/
(define *par-open* 0)
(define *bra-open* 0)

;*---------------------------------------------------------------------*/
;*    reader-reset! ...                                                */
;*---------------------------------------------------------------------*/
(define (reader-reset!)
   (set! *par-open* 0)
   (set! *bra-open* 0))

;*---------------------------------------------------------------------*/
;*    read ...                                                         */
;*---------------------------------------------------------------------*/
(define read
   (let* ((dot-symbol    (string->symbol ";"))
	  (grammar
	   (regular-grammar ((chiffre (>-< #\0 #\9))
			     (float   (! ((* chiffre) #\. (+ chiffre))
					 ((+ chiffre) #\. (* chiffre))))
			     (lettre  (>-< #\a #\z #\A #\Z #a128 #a255))
			     (special (in #\! #\@ #\~ #\$ #\%
					  #\^ #\& #\* #\> #\<
					  #\/ #\. #\- #\_ #\+   
					  #\\ #\| #\= #\? #\:))
			     (quote   (in #\" #\, #\' #\`))
			     (paren   (in #\( #\) #\[ #\] #\{ #\}))
			     (blank   (in #\space #\tab #\Newline))  
			     (id      ((! lettre chiffre special)
				       (* (! lettre chiffre special
					     #\, #\' #\`)))))
	      ((+ blank)                    ;; on oublie les separateurs
	       (ignore))
	      (("#!" (* (all)))           ;; le truc les interpretes
	       (set! *bigloo-interpreter* #t)
	       (ignore))
	      ((#\# #\\ (! lettre           ;; Les caracteres normaux
			   chiffre
			   special
			   #\#
			   quote
			   paren
			   ";"))
	       (string-ref (the-string) 2))
	      ((#\# #\a
		    chiffre
		    chiffre
		    chiffre)                ;; Les caracteres sous formes ascii
	       (integer->char (string->integer (substring (the-string) 2 5))))
	      ((";" (* (all)))              ;; de meme pour les commentaires
	       (ignore))
	      ((#\# #\\ (uncase "newline")) ;; retour charriot
	       #\newline)
	      ((#\# #\\ (uncase "tab"))     ;; tabulation
	       #\tab)
	      ((! (#\# #\\ (uncase "space"));; espace
		  (#\# #\\ #\space))
	       #\space)
	      ((#\# #\\ (uncase "return"))  ;; carriage return
	       (integer->char 13))
	      ((#\" (* (! (out #\\ #\")     ;; Les chaines de caracteres
			  (#\\ (all)))) #\")
	       (escape-scheme-string (the-small-string)))
	      ((#\# #\"                   ;; Les chaines de caracteres foreign
		    (* (! (out #\\ #\")  
			  (#\\ (all)))) #\")
	       (escape-C-string (the-small-string)))
	      (((! #\" (#\# #\"))         ;; Les bouts de chaines non termines
		(* (! (out #\\ #\")  
		      (#\\ (all)))))
	       (error "read" "Unexpected end-of-file" (the-string)))
	      ((! (+ chiffre)             ;; Les entiers
		  (#\- (+ chiffre))
		  (#\+ (+ chiffre)))
	       (string->integer (the-string) 10))
	      (("#o" (! (+ (>-< #\0 #\7)) ;; Les entiers en base 8
			((in #\+ #\-)
			 (>-< #\0 #\7))))
	       (string->integer (substring (the-string) 2 (the-length)) 8))
	      (("#d" (! (+ chiffre)       ;; Les entiers en base 10
			((in #\+ #\-)
			 chiffre)))
	       (string->integer (substring (the-string) 2 (the-length)) 10))
	      (("#x" (! (+ (! chiffre     ;; Les entiers en base 10
			      (>-< #\a #\f)
			      (>-< #\A #\F)))
			((in #\+ #\-)
			 (+ (! chiffre
			       (>-< #\a #\f)
			       (>-< #\A #\F))))))
	       (string->integer (substring (the-string) 2 (the-length)) 16))
	      ((! float                   ;; Les reels
		  ((in #\+ #\-) float)
		  ((! float (+ chiffre))
		   (in #\e #\E) (+ chiffre)) 
		  ((in #\+ #\-) (! float (+ chiffre)) (in #\e #\E) (+ chiffre))
		  ((! float (+ chiffre)) (in #\e #\E) (in #\+ #\-) (+ chiffre))
		  ((in #\+ #\-) (! float (+ chiffre))
				(in #\e #\E) (in #\+ #\-) (+ chiffre)))
	       (string->real (the-string)))
	      (pair (#\. (* blank) #\))
		    (error "read" "Illegal pair" (the-string)))
	      (pair (#\.)                ;; Le point des pairs pointees
		    dot-symbol)
	      ((#\.) 
	       (error "read" "Illegal token" #\.))
	      ((uncase "#t")             ;; true
	       #t)
	      ((uncase "#f")             ;; false
	       #f)
	      ((uncase "#unspecified")   ;;
	       (unspecified))
	      ((uncase "#<END-OF-FILE>")
	       beof)
	      (("#<" (! chiffre (>-< #\a #\z) (>-< #\A #\A))
		     (! chiffre (>-< #\a #\z) (>-< #\A #\A))
		     (! chiffre (>-< #\a #\z) (>-< #\A #\A))
		     (! chiffre (>-< #\a #\z) (>-< #\A #\A))
		     ">")
	       (make-cnst (string->integer (substring (the-string) 2 6) 16)))
	      ((! id (#\. (+ #\.)))      ;; Les identificateurs
	       (the-symbol))
	      ((#\')                     ;; Les simples quotations
	       (cons 'quote (cons (ignore) '())))
	      ((#\`)                     ;; Les quasiquotes
	       (cons 'quasiquote (cons (ignore) '())))
	      ((#\,)                     ;; Les unquotations
	       (cons 'unquote (cons (ignore) '())))
	      ((#\, #\@)                 ;; Les unquote-splicing
	       (cons 'unquote-splicing (cons (ignore) '())))
	      ((in #\( #\[)              ;; Les parentheses ouvrantes
	       (let ((open-key *par-open*))
		 (set! *par-open* (+fx 1 *par-open*))
		 (context 'pair) 
		 (let loop-pair ((walk (ignore)))
		   (cond
		    ((eq? walk dot-symbol) ;; une pair pointee
		     (context)
		     (let ((cdr (ignore)))
		       (ignore)
		       (if (=fx open-key *par-open*)
			   (begin
			     (context 'pair)
			     cdr)
			   (error "read" "Illegal pair" cdr))))
		    ((=fx open-key *par-open*)
		     (if (=fx open-key 0)
			 (context))
		     '())
		    (else
		     (cons walk (loop-pair (ignore))))))))
	      ((in #\) #\])              ;; Les parentheses fermantes
	       (set! *par-open* (-fx *par-open* 1))
	       (if (<fx *par-open* 0)
		   (begin
		     (set! *par-open* 0)
		     (ignore))
		   #f))
	      ((#\# #\()                 ;; Les debuts de vecteur
	       (let ((open-key *par-open*))
		  (set! *par-open* (+fx 1 *par-open*))
		  (list->vector (let loop-vector ((walk (ignore)))
				   (cond
				      ((=fx open-key *par-open*)
				       '())
			 	      (else
				       (cons walk (loop-vector (ignore)))))))))
	      ((#\# chiffre chiffre chiffre #\() ;; Les debuts de vect. (tages)
	       (let ((open-key *par-open*)
		     (tag      (string->integer (substring (the-string) 1 4))))
		  (set! *par-open* (+fx 1 *par-open*))
		  (let ((res (list->vector
			      (let loop-vector ((walk (ignore)))
				 (cond
				    ((=fx open-key *par-open*)
				     '())
				    (else
				     (cons walk (loop-vector (ignore)))))))))
		     (vector-tag-set! res tag)  
		     res)))
	      ((#\# #\{);; Les debuts des structures
	       (let ((open-key *bra-open*))
		  (set! *bra-open* (+fx 1 *bra-open*))
		  (cons '_structure_
			(let loop-struct ((walk (ignore)))
			   (cond
			      ((=fx open-key *bra-open*)
			       '())
			      (else
			       (cons walk
				     (loop-struct (ignore)))))))))
	      ((#\})
	       (set! *bra-open* (-fx *bra-open* 1))
	       (if (<fx *bra-open* 0)
		   (begin
		      (set! *bra-open* 0)
		      (ignore))
		   #f))
	      (else
	       (let ((char (the-failing-char)))
		 (if (eof-object? char)
		     (if (or (>fx *par-open* 0)
			     (>fx *bra-open* 0))
			 (begin
			    (reader-reset!)
			    (error "read" "Unexpected end-of-file" char))
			 (begin
			    (reset-eof input-port)
			    char))
		     (error "read"
			    "Illegal char"
			    (illegal-char-rep char))))))))
     (lambda input-port
	 (if (null? input-port)
	     (read/rp grammar (current-input-port))
	     (read/rp grammar (car input-port))))))


