;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Ieee/flonum.scm ...       */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov 26 14:04:03 1992                          */
;*    Last change :  Mon May 16 16:52:32 1994 (serrano)                */
;*                                                                     */
;*    6.5. Numbers (page 18, r4) The `flonum' functions                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_numbers_6_5_flonum
   (foreign (define bool   c-real?           (obj)           "REALP")
	    (define bool   c-eq.r            (breal breal)   "EQ_R")
	    (define bool   c-lt.r            (breal breal)   "LT_R")
	    (define bool   c-le.r            (breal breal)   "LE_R")
	    (define bool   c-gt.r            (breal breal)   "GT_R")
	    (define bool   c-ge.r            (breal breal)   "GE_R")
	    (define breal  c-add.r           (breal breal)   "ADD_R")
	    (define breal  c-sub.r           (breal breal)   "SUB_R")
	    (define breal  c-mul.r           (breal breal)   "MUL_R")
	    (define breal  c-div.r           (breal breal)   "DIV_R")
	    (define breal  c-neg.r           (breal)         "NEG_R")
	    (define bool   c-zerop.r         (breal)         "ZEROP_R")
	    (define bool   c-positivep.r     (breal)         "POSITIVEP_R")
	    (define bool   c-negativep.r     (breal)         "NEGATIVEP_R")
	    (define breal  c-abs.r           (breal)         "ABS_R")
	    (define double c-floor           (double)        "floor")
	    (define double c-ceiling         (double)        "ceil")
	    (define double c-exp             (double)        "exp")
	    (define double c-log             (double)        "log")
	    (define double c-sin             (double)        "sin")
	    (define double c-cos             (double)        "cos")
	    (define double c-tan             (double)        "tan")
	    (define double c-asin            (double)        "asin")
	    (define double c-acos            (double)        "acos")
	    (define double c-atan            (double)        "atan")
	    (define double c-atan2           (double double) "atan2")
	    (define double c-sqrt            (double)        "sqrt")
	    (define double c-pow             (double double) "pow")
	    (string        c-real->string    (double)        "real_to_string")
	    (double        strtod            (string long)   "strtod"))
   (export  (inline real? obj)
	    (inline =fl             r1 r2)
	    (inline >fl             r1 r2)
	    (inline >=fl            r1 r2)
	    (inline <fl             r1 r2)
	    (inline <=fl            r1 r2)
	    (inline zerofl?         r)
	    (inline positivefl?     r)
	    (inline negativefl?     r)
	    (maxfl                  r1 . rn)
	    (minfl                  r1 . rn)
	    (inline +fl             r1 r2)
	    (inline -fl             r1 r2)
	    (inline *fl             r1 r2)
	    (inline /fl             r1 r2)
	    (inline negfl           r)
	    (inline absfl           r)
	    (inline floorfl         r)
	    (inline ceilingfl       r)
	    (inline truncatefl      r)
	    (inline roundfl         r)
	    (inline expfl           r)
	    (inline logfl           r)
	    (inline sinfl           r)
	    (inline cosfl           r)
	    (inline tanfl           r)
	    (inline asinfl          r)
	    (inline acosfl          r)
	    (inline atanfl          x . y)
	    (inline sqrtfl          r)
	    (inline exptfl          x y)
	    (inline string->real    string)
	    (inline real->string    x))
      (pragma  (c-real? _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-eq.r _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-lt.r _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-le.r _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-gt.r _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-ge.r _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-add.r _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-sub.r _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-mul.r _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-div.r _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-neg.r _no_side_effect_ _imbricable_)
	    (c-zerop.r _no_side_effect_ _imutable_ _no_mutation_ _imutable_ _no_mutation_ _imbricable_)
	    (c-positivep.r _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)
	    (c-negativep.r _no_side_effect_ _imutable_ _no_mutation_ _imbricable_)))
	    
	    
;*---------------------------------------------------------------------*/
;*    real? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (real? obj)
   (or (c-integer? obj) (c-real? obj)))

;*---------------------------------------------------------------------*/
;*    =fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (=fl r1 r2)
   (c-eq.r r1 r2))

;*---------------------------------------------------------------------*/
;*    <fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (<fl r1 r2)
   (c-lt.r r1 r2))

;*---------------------------------------------------------------------*/
;*    >fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (>fl r1 r2)
   (c-gt.r r1 r2))

;*---------------------------------------------------------------------*/
;*    <=fl ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (<=fl r1 r2)
   (c-le.r r1 r2))

;*---------------------------------------------------------------------*/
;*    >=fl ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (>=fl r1 r2)
   (c-ge.r r1 r2))

;*---------------------------------------------------------------------*/
;*    zerofl? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (zerofl? r)
   (c-zerop.r r))

;*---------------------------------------------------------------------*/
;*    positivefl? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (positivefl? r)
   (c-positivep.r r))

;*---------------------------------------------------------------------*/
;*    negativefl? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (negativefl? r)
   (c-negativep.r r))

;*---------------------------------------------------------------------*/
;*    +fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (+fl r1 r2)
   (c-add.r r1 r2))
	    
;*---------------------------------------------------------------------*/
;*    -fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (-fl r1 r2)
   (c-sub.r r1 r2))

;*---------------------------------------------------------------------*/
;*    *fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (*fl r1 r2)
   (c-mul.r r1 r2))

;*---------------------------------------------------------------------*/
;*    /fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (/fl r1 r2)
   (c-div.r r1 r2))

;*---------------------------------------------------------------------*/
;*    negfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (negfl r1)
   (c-neg.r r1))
    
;*---------------------------------------------------------------------*/
;*    maxfl ...                                                        */
;*---------------------------------------------------------------------*/
(define (maxfl r1 . rn)
   (let loop ((max r1)
	      (rn  rn))
      (if (null? rn)
	  max
	  (if (>fl (car rn) max)
	      (loop (car rn) (cdr rn))
	      (loop max (cdr rn))))))
   
;*---------------------------------------------------------------------*/
;*    minfl ...                                                        */
;*---------------------------------------------------------------------*/
(define (minfl r1 . rn)
   (let loop ((min r1)
	      (rn  rn))
      (if (null? rn)
	  min
	  (if (<fl (car rn) min)
	      (loop (car rn) (cdr rn))
	      (loop min (cdr rn))))))
   
;*---------------------------------------------------------------------*/
;*    absfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (absfl r)
   (c-abs.r r))

;*---------------------------------------------------------------------*/
;*    floorfl ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (floorfl r)
   (c-floor r))

;*---------------------------------------------------------------------*/
;*    ceilingfl ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (ceilingfl r)
   (c-ceiling r))

;*---------------------------------------------------------------------*/
;*    truncatefl ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (truncatefl r)
   (if (negativefl? r)
       (ceilingfl r)
       (floorfl r)))

;*---------------------------------------------------------------------*/
;*    roundfl ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (roundfl r)
   (c-floor (c-add.r r 0.5)))

;*---------------------------------------------------------------------*/
;*    expfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (expfl x)
   (c-exp x))

;*---------------------------------------------------------------------*/
;*    logfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (logfl x)
   (c-log x))
 
;*---------------------------------------------------------------------*/
;*    sinfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (sinfl x)
   (c-sin x))

;*---------------------------------------------------------------------*/
;*    cosfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cosfl x)
   (c-cos x))

;*---------------------------------------------------------------------*/
;*    tanfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (tanfl x)
   (c-tan x))

;*---------------------------------------------------------------------*/
;*    asinfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (asinfl x)
   (c-asin x))

;*---------------------------------------------------------------------*/
;*    acosfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (acosfl x)
   (c-acos x))

;*---------------------------------------------------------------------*/
;*    atanfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (atanfl x . y)
   (if (null? y)
       (c-atan x)
       (c-atan2 x (car y))))

;*---------------------------------------------------------------------*/
;*    sqrtfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (sqrtfl r)
   (c-sqrt r))

;*---------------------------------------------------------------------*/
;*    exptfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (exptfl r1 r2)
   (c-pow r1 r2))

;*---------------------------------------------------------------------*/
;*    string->real ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (string->real string)
   (strtod string 0))


;*---------------------------------------------------------------------*/
;*    real->string ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (real->string real)
   (c-real->string real))
