;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Parse/module.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Mar 17 15:10:03 1993                          */
;*    Last change :  Thu Mar  3 14:49:22 1994 (serrano)                */
;*                                                                     */
;*    On parse les clauses d'une definition de module                  */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module parse_module
   (include "Tools/trace.sch")
   (import  engine_param
	    engine_engine
	    parse_include
	    parse_statexp
	    parse_import
	    parse_foreign
	    parse_with
	    parse_top-level
	    parse_load
	    heap_restore
	    var_pragma)
   (export  (parse-module module-declaration)))

;*---------------------------------------------------------------------*/
;*    parse-module ...                                                 */
;*    -------------------------------------------------------------    */
;*    La syntaxe d'une declaration de module est:                      */
;*       (module symbol                                                */
;*               import-clause                                         */
;*               use-clause                                            */
;*               static-clause                                         */
;*               export-clause                                         */
;*               foreign-clause                                        */
;*               with-clause                                           */
;*               main-clause                                           */
;*               include-clause                                        */
;*               pragma-clause                                         */
;*               top-level-clause                                      */
;*               ordre-clause                                          */
;*               load-clause)                                          */
;*                                                                     */
;*    Les includes peuvent contenir des directives d'importations. Il  */
;*    faut donc les lires avant de traiter les imports.                */
;*---------------------------------------------------------------------*/
(define (parse-module module-exp)
   (if (not (and (pair? module-exp)
		 (eq? (car module-exp) 'module)
		 (pair? (cdr module-exp))
		 (symbol? (cadr module-exp))))
       (if *bigloo-interpreter*
	   ;; ah ah, ce qu'on veut c'est en fait interpreter le fichier
	   (begin
	      (set! *interpreter* #t)
	      (exit (bigloo)))
	   ;; non, il y a bien une erreur
	   (begin
	      (hello-world)
	      (error "parse-module"
		     "incorrect module declaration"
		     module-exp)))
       (begin
	  ;; c'est bon, on peut enfin afficher en toutes quietude le
	  ;; nom du fichier qu'on va compiler.
	  (hello-world)
	  ;; on commence par lire le fichier de tas.
	  ;; en lisant tout de suite, on n'aura pas de pbm de savoir
	  ;; dans quel ordre sont definies les choses (pbm de redefinition).
	  (if (not (eq? *pass* 'make-heap))
	      ;; bien sur, on ne charge le tas que si on n'est pas en train
	      ;; de le definir !
	      (restore-heap))
	  ;; Si on n'a pas sur-defini un nom de module, on en definit un.
	  (if (not *module-name*)
	      (set! *module-name* (cadr module-exp)))
	  ;; On lit les clauses du module
	  (let loop ((module-clauses (cddr module-exp))
		     (import         '())
		     (export         '())
		     (static         '())
		     (foreign        '())
		     (include        *bigloo-user-includes*)
		     (with           '())
		     (pragma         '())
		     (top-level      '()))
	     (if (null? module-clauses)
		 (begin
		    (trace init
			   "-------------------------------------------------"
			   #\Newline
			   "module     : " *module-name* #\newline
			   "src        : " (if (string? *src*)
					      *src*
					      "[stdin]")
			   #\Newline
			   "heap-names : " *heap-names* #\Newline
			   "-------------------------------------------------"
			   #\Newline
			   "import   : " import
			   #\Newline
			   "export   : " export
			   #\Newline
			   "static   : " static
			   #\Newline
			   "foreign  : " foreign
			   #\Newline
			   "include  : " include
			   #\Newline
			   "pragma   : " pragma
			   #\Newline
			   "top-level: " top-level
			   #\Newline #\Newline)
		    (let ((read-include (parse-include (reverse include))))
		       (parse-import (reverse (append import
						      (car read-include))))
		       ;; on ne parse les `export' et les `static' qu'apres
		       ;; avoir declarer les variables importees. En respectant
		       ;; cet ordre, on n'a pas de pbm de redefinition.
		       (parse-export export)
		       (parse-static static)
		       (parse-top-level top-level)
		       (parse-foreign (append (cadr read-include) foreign)
				      'export)
		       (parse-with with)
		       (parse-main *main*)
		       (put-pragma! pragma)
		       (reverse (caddr read-include))))
		 (let ((clause (car module-clauses)))
		    (if (not (pair? clause))
			(error "parse-module"
			       "illegal module clause"
			       clause)
			(case (car clause)
			   ((main)
			    (if (null? (cdr clause))
				(error "parse-module-and-declaration"
				       "Illegal main clause"
				       clause)
				(if (not (string? *main*))
				    (set! *main* (cadr clause))))
			    (loop (cdr module-clauses) import export
				  static foreign include with pragma
				  top-level))
			   ((import)
			    ;; attention, on construit la liste des
			    ;; export a l'envers. Pour ne pas avoir
			    ;; de pbm lors de la redefinition des
			    ;; fonction, il faudra inverser cette list.
			    (loop (cdr module-clauses)
				  (append (cdr clause) import)
				  export static foreign
				  include with pragma top-level))
			   ((load)
			    ;; on lit les fichiers loades, a la volee
			    (parse-load clause)
			    (loop (cdr module-clauses)
				  import export static foreign
				  include with pragma top-level))
			   ((use)
			    (for-each (lambda (u)
					 (set! *used-modules*
					       (cons (if (pair? u)
							 (car u)
							 u)
						     *used-modules*)))
				      (cdr clause))
			    (loop (cdr module-clauses)
				  (append (cdr clause) import)
				  export static foreign
				  include with pragma top-level))
			   ((force)
			    (set! *order-init-modules*
				  (append *order-init-modules*
					  (map (lambda (x)
						  (if (pair? x)
						      (car x)
						      x))
					       (cdr clause))))
			    (loop (cdr module-clauses)
				  import
				  export static foreign
				  include with pragma top-level))
			   ((export)
			    (loop (cdr module-clauses)
				  import
				  (append (cdr clause) export)
				  static foreign include with pragma
				  top-level))
			   ((static)
			    (loop (cdr module-clauses)
				  import export
				  (append (cdr clause) static)
				  foreign include with pragma
				  top-level))
			   ((foreign)
			    (loop (cdr module-clauses)
				  import export static
				  (append (cdr clause) foreign)
				  include with pragma top-level))
			   ((with)
			    (loop (cdr module-clauses)
				  import export static foreign include
				  (append (cdr clause) with)
				  pragma top-level))
			   ((include)
			    (loop (cdr module-clauses)
				  import export static foreign
				  (append (reverse (cdr clause)) include)
				  with pragma top-level))
			   ((pragma)
			    (loop (cdr module-clauses)
				  import export static foreign include with
				  (append (cdr clause) pragma) top-level))
			   ((top-level)
			    (loop (cdr module-clauses)
				  import export static foreign include with
				  pragma
				  (append (cdr clause) top-level)))
			   (else
			    (error "parse-module"
				   "Illegal module clause"
				   clause))))))))))


