;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Heap/compact.scm ...     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jun 24 12:56:22 1992                          */
;*    Last change :  Fri Dec 10 16:03:50 1993 (serrano)                */
;*                                                                     */
;*    On compacte et decompacte les objects a sauver                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module heap_compact
   (include "Var/variable.sch"
	    "Foreign/type.sch")
   (import  tools_shape
	    tools_args
	    foreign_tools
	    var_declare)
   (export  (compact global)
	    (uncompact! r)))

;*---------------------------------------------------------------------*/
;*    compact ...                                                      */
;*---------------------------------------------------------------------*/
(define (compact global)
   (case (global-class global)
      ((function)
       (compact-function global))
      ((variable)
       (compact-variable global))
      ((foreign)
       (compact-foreign global))
      (else
       (error "compact" "Unknown object type" (shape global)))))

;*---------------------------------------------------------------------*/
;*    compact-function ...                                             */
;*---------------------------------------------------------------------*/
(define (compact-function global)
   (let ((function (global-value global)))
      (vector (global-class               global)
	      (global-name                global)
	      (global-module              global)
	      (global-c-name              global)
	      (function-arity             function)
	      (and (boolean? (function-inline? function))
		   (function-inline? function))
	      (if (and (boolean? (function-inline? function))
		       (function-inline? function))
		  (list (shape (function-body function))
			(shape (function-args function)))
		  #f)
	      (global-pragma              global))))

;*---------------------------------------------------------------------*/
;*    compact-variable ...                                             */
;*---------------------------------------------------------------------*/
(define (compact-variable global)
   (vector (global-class  global)
	   (global-name   global)
	   (global-module global)
	   (global-c-name global)))

;*---------------------------------------------------------------------*/
;*    compact-foreign ...                                              */
;*---------------------------------------------------------------------*/
(define (compact-foreign global)
   (vector (global-class  global)
	   (global-name   global)
	   (global-c-name global)
	   (foreign-class (global-value global))
	   (compact-type  (foreign-type (global-value global)))
	   (global-pragma global)))

;*---------------------------------------------------------------------*/
;*    uncompact! ...                                                   */
;*---------------------------------------------------------------------*/
(define (uncompact! r)
   (case (vector-ref r 0)
      ((function)
       (uncompact-function! r))
      ((variable)
       (uncompact-variable! r))
      ((foreign)
       (uncompact-foreign! r))
      (else
       (error "uncompact!" "Unknown object type" (shape r)))))

;*---------------------------------------------------------------------*/
;*    uncompact-function! ...                                          */
;*---------------------------------------------------------------------*/
(define (uncompact-function! r)
   (let ((class   (vector-ref r 0))
	 (name    (vector-ref r 1))
	 (module  (vector-ref r 2))
	 (c-name  (vector-ref r 3))
	 (arity   (vector-ref r 4))
	 (inline? (vector-ref r 5))
	 (pragma  (vector-ref r 7)))
      (if inline?
	  (let ((body (car (vector-ref  r 6)))
		(args (cadr (vector-ref r 6))))
	     (let ((global (declare-global-inline! (if (string? c-name)
						       c-name
						       name)
						   args
						   module 'import)))
		(function-body-set!  (global-value global) body)
		(if (>=fx arity 0)
		    (function-args-set! (global-value global) args)
		    (function-args-set! (global-value global)
					(args*->args-list args)))
		(global-library?-set! global #t)
		(global-pragma-set!   global pragma)
		global))
	  (let ((args (make-n-proto arity)))
	     (let ((global (declare-global-procedure! (if (string? c-name)
							  c-name
							  name)
						      args
						      module 'import)))
		(if (>=fx arity 0)
		    (function-args-set! (global-value global) args)
		    (function-args-set! (global-value global)
					(args*->args-list args)))
		(global-library?-set! global #t)
		(global-pragma-set!   global pragma)
		global)))))

;*---------------------------------------------------------------------*/
;*    uncompact-variable! ...                                          */
;*---------------------------------------------------------------------*/
(define (uncompact-variable! r)
   (let ((class   (vector-ref r 0))
	 (name    (vector-ref r 1))
	 (module  (vector-ref r 2))
	 (c-name  (vector-ref r 3)))
      (let ((global (declare-global-variable! (if (string? c-name)
						  c-name
						  name)
					      module
					      'import)))
	 (global-library?-set! global #t)
	 global)))

;*---------------------------------------------------------------------*/
;*    uncompact-foreign! ...                                           */
;*---------------------------------------------------------------------*/
(define (uncompact-foreign! r)
    (let ((class          (vector-ref r 0))
	  (name           (vector-ref r 1))
	  (c-name         (vector-ref r 2))
	  (function-class (vector-ref r 3))
	  (function-type  (uncompact-type (vector-ref r 4)))
	  (pragma         (vector-ref r 5)))
       (if (or (eq? function-class 'function)
	       (eq? function-class 'macro-function))
	   (let ((global (declare-global-foreign! name
						  c-name
						  function-type
						  function-class)))
	      (global-library?-set! global #t)
	      (global-pragma-set!   global pragma)
	      global)
	   (let ((global (declare-global-foreign! name
						  c-name
						  function-type
						  function-class)))
	      (global-library?-set! global #t)
	      (global-pragma-set!   global pragma)
	      global))))

;*---------------------------------------------------------------------*/
;*    compact-type ...                                                 */
;*---------------------------------------------------------------------*/
(define (compact-type type)
   (cond
      ((not (eq? (type-type type) 'function))
       (type-id type))
      (else
       (cons '-> (cons (type-id (car (type-exp type)))
		       (map-on-args! (lambda (type)
					(if (type? type)
					    (type-id type)
					    type))
				     (cdr (type-exp type))))))))

;*---------------------------------------------------------------------*/
;*    uncompact-type ...                                               */
;*---------------------------------------------------------------------*/
(define (uncompact-type type)
   (if (not (pair? type))
       (get-type type)
       (let ((to    (get-type     (cadr type)))
	     (from  (map-on-args! get-type (cddr type))))
	  (make/get-function-type! to from))))

