;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.0/Llib/sys.scm ...                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 13 17:05:24 1993                          */
;*    Last change :  Mon Mar 14 08:38:40 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    System interface                                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_sys
   (foreign (include "signal.h")
	    (include "caml-bigloo.h")
            (obj sys_open  (obj obj obj) "sys_open")
	    (obj sys_close (obj)         "sys_close")
	    (obj sys_exit  (obj)         "bigloo_exit")
	    (obj sys_error ()            "sys_error")
	    (define int s_irall_56@sys   "SYS__S_IRALL")
	    (define int s_iwall_219@sys  "SYS__S_IWALL"))
   (import  (__caml_handle "Llib/handle.scm"))
   (export  command_line_240@sys
	    interactive_191@sys
	    (inline sys_remove s)
	    (inline sys_rename a b)
	    (inline sys_getenv s)
	    (sys_chdir d)
	    (sys_catch_break flag)))
  
;*---------------------------------------------------------------------*/
;*    command_line ...                                                 */
;*---------------------------------------------------------------------*/
(define command_line_240@sys command_line_240@sys)

;*---------------------------------------------------------------------*/
;*    interactive ...                                                  */
;*---------------------------------------------------------------------*/
(define interactive_191@sys #f)

;*---------------------------------------------------------------------*/
;*    sys_remove ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (sys_remove s)
   (delete-file s))

;*---------------------------------------------------------------------*/
;*    sys_rename ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (sys_rename a b)
   (rename-file a b))

;*---------------------------------------------------------------------*/
;*    sys_getenv ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (sys_getenv s)
   (getenv s))
   
;*---------------------------------------------------------------------*/
;*    sys_chdir ...                                                    */
;*---------------------------------------------------------------------*/
(define (sys_chdir dirname)
   (if (not (=fx (chdir dirname) 0))
       (sys_error)
       '#<0000>))

;*---------------------------------------------------------------------*/
;*    sys_catch_break ...                                              */
;*---------------------------------------------------------------------*/
(define (sys_catch_break flag)
   (if flag
       (signal SIGINT (lambda (x) (raise 'break@sys)))
       (signal SIGINT sys_exit)))
