/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/ml/camloo/runtime0.1/Clib/string.c ...                   */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Apr  1 16:50:30 1994                          */
/*    Last change :  Fri Apr  1 16:50:57 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    La gestion C des chaines de caracteres                           */
/*=====================================================================*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    compare_strings ...                                              */
/*---------------------------------------------------------------------*/
obj_t
compare_strings( o1, o2 )
obj_t o1, o2;
{
	int   len1, len2, len;
	char *p1, *p2;
	int   i;
	
	
	len1 = CINT( STRING_LENGTH( o1 ) );
	len2 = CINT( STRING_LENGTH( o2 ) );

	p1 = BSTRING_TO_CSTRING( o1 );
	p2 = BSTRING_TO_CSTRING( o2 );

	for( len = (len1 <= len2 ? len1 : len2); len > 0; len--, p1++, p2++ )
	   if (*p1 != *p2)
		   return (*p1 < *p2 ? BINT( -1 ) : BINT( 1 ) );

	if( len1 == len2 )
	   return BINT( 0 );
	else
	   if( len1 < len2 )
		   return BINT( -2 );
	   else
		   return BINT( 2 );
}
