/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/ml/camloo/runtime0.0/Clib/setjmp.c ...                   */
/*    -------------------------------------------------------------    */
/*    Author      :  Robert Ehrlich                                    */
/*    Creation    :  Tue Feb  8 19:50:58 1994                          */
/*    Last change :  Wed Feb  9 09:46:04 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Un setjmp plus restreint mais plus efficace pour la compilation  */
/*    du couple `try/raise'                                            */
/*=====================================================================*/

#if( defined( sparc ) || defined( SPARC ) )
#   if( defined( __svr4__ ) )
    asm("        .globl  __setjmp");
    asm("__setjmp:");
#   else		
    asm("        .globl  ___setjmp");
    asm("___setjmp:");
#   endif		 
    asm("        st      %sp,[%o0]");
    asm("        st      %o7,[%o0+4]");
    asm("        retl");
    asm("        clr     %o0");
    asm("");
#   if( defined( __svr4__ ) )
    asm("        .globl  __longjmp");
    asm("__longjmp:");
#else		 
    asm("        .globl  ___longjmp");
    asm("___longjmp:");
#   endif		 
    asm("        ld      [%o0],%g1");
    asm("        ld      [%o0+4],%g2");
    asm("        mov     %o1,%g3");
    asm("        cmp     %sp,%g1");
    asm("        bgeu    1f");
    asm("        cmp     %fp,%g1");
    asm("2:      restore");
    asm("        blu     2b");
    asm("        cmp     %fp,%g1");
    asm("1:");
    asm("        jmp     %g2+8");
    asm("        mov     %g3,%o0");
#endif
