;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;; Le module                                                                 
(module
  __caml_errors
  (foreign (include #"caml-bigloo.h"))
  (import
    (__caml_location #"location.scm")
    (__camli_location #"location.sci")
    (__caml_misc #"misc.scm")
    (__caml_globals #"globals.scm")
    (__caml_const #"const.scm"))
  (export
    (print_qualid_104@errors x1)
    (prerr_qualid_47@errors x1)
    (print_globalref_211@errors x1)
    (prerr_globalref_125@errors x1)
    (unbound_err_215@errors x1)
    (3-182-unbound_err_215@errors x1 x2 x3)))
;; L'initialisation du module                                                
(init_camloo!)
;; Les variables globales                                                    
;; Les expressions globales                                                  
(define print_qualid_104@errors
  (lambda (x1)
    (begin
      (print_string_98@io (caml-constr-get-field x1 0))
      (begin
        (print_string_98@io #"__")
        (print_string_98@io (caml-constr-get-field x1 1))))))

(define prerr_qualid_47@errors
  (lambda (x1)
    (begin
      (prerr_string_235@io
        (caml-constr-get-field x1 0))
      (begin
        (prerr_string_235@io #"__")
        (prerr_string_235@io
          (caml-constr-get-field x1 1))))))

(define print_globalref_211@errors
  (lambda (x1)
    (case (caml-regular-constr-tag x1)
      ((1)
       (print_string_98@io (caml-constr-get-field x1 0)))
      (else
       (print_qualid_104@errors
         (caml-constr-get-field x1 0))))))

(define prerr_globalref_125@errors
  (lambda (x1)
    (case (caml-regular-constr-tag x1)
      ((1)
       (prerr_string_235@io
         (caml-constr-get-field x1 0)))
      (else
       (prerr_qualid_47@errors
         (caml-constr-get-field x1 0))))))

(begin
  (define unbound_err_215@errors
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (3-182-unbound_err_215@errors x1 x2 x3)))))
 (define 3-182-unbound_err_215@errors
    (lambda (x1 x2 x3)
      (begin
        (prerr_location_1@location x3)
        (begin
          (prerr_begline_213@misc #" ")
          (begin
            (prerr_string_235@io x1)
            (begin
              (prerr_string_235@io #" ")
              (begin
                (prerr_globalref_125@errors x2)
                (begin
                  (prerr_endline_232@io #" is unbound.")
                  (raise 'toplevel_2@misc)))))))))
)
