;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../definition.scm ...                                           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr  3 10:24:26 1993                          */
;*    Last change :  Thu Jan 20 09:50:53 1994 (serrano)                */
;*                                                                     */
;*    On genere une definition                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cgen_definition
   (include "Cgen/cgen.sch"
	    "Var/variable.sch"
	    "Tools/trace.sch")
   (import  engine_param
	    tools_shape
	    foreign_atomic
	    cgen_identificator
	    cgen_s2c)
   (export  (cgen-definition! exp)
	    (get-local-cgen! local)
	    (get-global-cgen! global)
	    (get-local-definitions)))

;*---------------------------------------------------------------------*/
;*    *remember-local*                                                 */
;*---------------------------------------------------------------------*/
(define *remember-local* '())

;*---------------------------------------------------------------------*/
;*    get-local-definitions ...                                        */
;*---------------------------------------------------------------------*/
(define (get-local-definitions)
   *remember-local*)

;*---------------------------------------------------------------------*/
;*    remember-local-definition! ...                                   */
;*---------------------------------------------------------------------*/
(define (remember-local-definition! var)
   (set! *remember-local* (cons var *remember-local*)))

;*---------------------------------------------------------------------*/
;*    get-global-cgen! ...                                             */
;*---------------------------------------------------------------------*/
(define (get-global-cgen! global)
   (if (cgen? (global-info global))
       (global-info global)
       (let ((new (make-cgen)))
	  (global-info-set!  global new)
	  (cgen-c-name-set!  new (c-global-id global))
	  (cgen-c-label-set! new (string-append  "_"
						 (cgen-c-name new)))
	  new)))
	  
;*---------------------------------------------------------------------*/
;*    get-local-cgen! ...                                              */
;*---------------------------------------------------------------------*/
(define (get-local-cgen! local)
   (if (cgen? (local-info local))
       (local-info local)
       (let ((new (make-cgen)))
	  (local-info-set!   local new)
	  (cgen-G?-set!      new #f)
	  (cgen-c-name-set!  new (c-local-id local))
	  (cgen-c-label-set! new (string-append "_"
						(cgen-c-name new)))
	  (cgen-type-set!    new (local-type local))
	  new)))
	      
;*---------------------------------------------------------------------*/
;*    cgen-definition! ...                                             */
;*---------------------------------------------------------------------*/
(define (cgen-definition! var)
   (trace cgen "cgen-definition!: " (shape var) #\Newline)
   (make-c-definition! var))

;*---------------------------------------------------------------------*/
;*    make-c-definition! ...                                           */
;*---------------------------------------------------------------------*/
(define (make-c-definition! var)
   (trace cgen "make-c-definition!: " (shape var) #\Newline)
   (let (value cgen formals body)
      (cond
	 ((global? var)
	  (set! value   (global-value var))
	  (set! formals (function-args value))
	  (set! body    (function-body value))
	  (set! cgen    (get-global-cgen! var)))
	 ((local? var) 
	  (set! value (local-value var))
	  (set! cgen  (get-local-cgen! var))
	  (cgen-G?-set! cgen #t)
	  (remember-local-definition! var)
	  (cond
	     ((eq? (local-class var) 'function)
	      (set! formals (function-args value))
	      (set! body    (function-body value)))
	     ((eq? (local-class var) 'return)
	      (set! formals (return-args value))
	      (set! body    (return-body value)))
	     (else
	      (error "make-c-definition!" "Illegal expression" (shape var)))))
	 (else
	  (error "make-c-definition!" "Illegal form" (shape var))))
      (for-each get-local-cgen! formals)
      (let ((c-code `(begin 
			(label ,(cgen-c-label cgen))
			,(sqil->c body (make-return-kont var)))))
	 (cgen-c-abstract-code-set! cgen c-code)
	 (cgen-c-args-set!          cgen formals)
	 var)))



