;;;;  Please remember that you do not need to runn this code in order
;;;;  to prepare for the final.  If you do want to play with lottery
;;;;  experiments, though, you can do so as follows:
;;;;  CATALOG is a sample catalog of subjects.  You can change this if
;;;;  you like.  Running (INIT N) will generate a list call STUDS of 
;;;;  T-N student records, where T
;;;;  is the combined capacity of all the subjects in the catalog.  Then run,
;;;;  for example,
;;;;  (DEFINE RESULT (LOTTERY-1 <your desired chooser> STUDS CATALOG))
;;;;  After that you can examine RESULT to see the unplaced students
;;;;  and unfilled subjects, and examine CATALOG to see the
;;;;  assignments.  You need to rerun INIT before each experiment.



;;;;      HASS Lottery Experiment (HASSLE)

;;; The purpose of this experiment is to allow students 
;;; to evaluate strategies for choosing their preference
;;; order to maximize their probability of getting close
;;; to their first choice.

;;; There are students and there are subjects

;;; A student has a name, a list of HASS-D preferences,
;;; their current HASS-D assignment, and maybe other
;;; properties (history, password)

(define (make-student name preference-nums)
  (list name preference-nums '()))

(define (student-name student)
  (list-ref student 0))

(define (student-preference-nums student)
  (list-ref student 1))

(define (student-preferences student)
  (map (lambda (subject-number) (assq subject-number catalog))
       (student-preference-nums student)))

(define (student-current-assignment student)
  (list-ref student 2))

(define (set-student-current-assignment! student new-assignment)
  (set-car! (list-tail student 2) new-assignment))

;;; A subject has a name, a capacity, a current list of
;;; students assigned to it, a list of students provisionally assigned,
;;; and a popularity...

(define (make-subject number name instructor capacity popularity)
  ;;students provisional-students
  (list number name instructor capacity '() '() popularity))

(define (subject-number subject)
  (list-ref subject 0))

(define (subject-name subject)
  (list-ref subject 1))

(define (subject-instructor subject)
  (list-ref subject 2))

(define (subject-capacity subject)
  (list-ref subject 3))

(define (subject-students subject)
  (list-ref subject 4))

(define (set-subject-students! subject students)
  (set-car! (list-tail subject 4) students))

(define (subject-enrollment subject)
  (length (subject-students subject)))

(define (subject-provisional-students subject)
  (list-ref subject 5))

(define (set-subject-provisional-students! subject students)
  (set-car! (list-tail subject 5) students))

(define (total-enrollment subject)
  (+ (length (subject-students subject))
     (length (subject-provisional-students subject))))

(define (subject-popularity subject)
  (list-ref subject 6))

(define (full? subject)
  (>= (total-enrollment subject)
      (subject-capacity subject)))

(define (assign-to-subject! subject student)
  (set-subject-students! subject
			 (cons student (subject-students subject)))
  (set-student-current-assignment! student (subject-number subject)))

(define (provisionally-assign! subject student)
  (set-subject-provisional-students! subject
    (cons student (subject-provisional-students subject)))
  (set-student-current-assignment! student
				   (subject-number subject)))

(define (unassign! subject student)
  (set-subject-students! subject
    (delete student (subject-students subject)))
  (set-subject-provisional-students! subject
    (delete student (subject-provisional-students subject)))
  (set-student-current-assignment! student '()))

(define (complete-assignments! subject)
  (set-subject-students! subject
   (append (subject-students subject)
	   (subject-provisional-students subject)))
  (set-subject-provisional-students! subject '()))

;;; One interpretation of the APPENDIX...

(define (lottery-1 chooser students subjects)
  (let ((unassignable-students '())
	(open-subjects '()))
    (for-each (lambda (student)
		(assign-to-subject! (car (student-preferences student))
				    student))
	      students)
    (for-each (lambda (subject)
		(if (full? subject)
		    (for-each (lambda (loser)
				(unassign! subject loser)
				(set! unassignable-students
				      (cons loser unassignable-students)))
			      (chooser (- (subject-enrollment subject)
					  (subject-capacity subject))
				       (subject-students subject)))
		    (set! open-subjects
			  (cons subject open-subjects))))
	      subjects)
    (for-each (lambda (student)
		(define (search preferences)
		  (if (null? preferences)
		      'done
		      (let ((pref (car preferences)))
			(if (member pref open-subjects)
			    (begin (assign-to-subject! pref student)
				   (set! unassignable-students
					 (delete student unassignable-students))
				   (if (full? pref)
				       (set! open-subjects
					     (delete pref open-subjects))))
			    (search (cdr preferences))))))
		(search (cdr (student-preferences student))))
	      unassignable-students)
    (list unassignable-students open-subjects)))


(define (lottery-2 chooser unassigned-students open-subjects)
  (let ((unassignable-students '()))
    (define (phase n)
      (if (null? unassigned-students)
	  'done
	  (begin
	    (for-each (lambda (student)
			(if (> (length (student-preferences student)) n)
			    (begin
			      (provisionally-assign!
			       (list-ref (student-preferences student) n)
			       student)
			      (set! unassigned-students
				    (delete student unassigned-students)))
			    (begin
			      (set! unassignable-students
				    (cons student unassignable-students))
			      (set! unassigned-students
				    (delete student unassigned-students)))))
		      unassigned-students)
	    (for-each (lambda (subject)
			(if (full? subject)
			    (begin
			      (for-each (lambda (loser)
					  (unassign! subject loser)
					  (set! unassigned-students
						(cons loser unassigned-students)))
					(chooser
					 (- (total-enrollment subject)
					    (subject-capacity subject))
					 (subject-provisional-students subject)))
				   (set! open-subjects
					 (delete subject open-subjects))))
			(complete-assignments! subject))
		      open-subjects)
	    (phase (+ n 1)))))
    (phase 0)
    (list unassignable-students open-subjects)))

(define (lottery-3 chooser unassigned-students open-subjects)
  (let ((unassignable-students '()))
    (define (phase n)
      (if (null? unassigned-students)
	  'done
	  (begin
	    (for-each (lambda (student)
			(if (> (length (student-preferences student)) n)
			    (begin
			      (assign-to-subject!
			       (list-ref (student-preferences student) n)
			       student)
			      (set! unassigned-students
				    (delete student unassigned-students)))
			    (begin
			      (set! unassignable-students
				    (cons student unassignable-students))
			      (set! unassigned-students
				    (delete student unassigned-students)))))
		      unassigned-students)
	    (for-each (lambda (subject)
			(if (full? subject)
			    (begin (for-each (lambda (loser)
					       (unassign! subject loser)
					       (set! unassigned-students
						     (cons loser unassigned-students)))
					     (chooser (- (subject-enrollment subject)
							 (subject-capacity subject))
						      (subject-students subject)))
				   (set! open-subjects
					 (delete subject open-subjects)))))
		      open-subjects)
	    (phase (+ n 1)))))
    (phase 0)
    (list unassignable-students open-subjects)))

(define (make-catalog)
  ;;             Number   Name                                      Instructor   Cap. Pop.
  (list
   (make-subject '9:00    "Introduction to Psychology"              "J. Wolfe"    12  20)
   (make-subject '21M:301 "Harmony and Counterpoint I"              "E. Cohen"     5   9)
   (make-subject '21A:469 "It's Not Easy Being Green"               "K. The Frog"  4   3)
   (make-subject '21A:215 "The Hermaphroditic Family"               "N. Earthworm" 4   2)
   (make-subject '21H:136 "UFOs in the Bible"                       "Ezekiel"      5   5)
   (make-subject '21L:022 "Canine-American Heroic Epics"            "Lassie"       4   7)
   (make-subject '21L:490 "Deconstructionism in Scheme Programming" "Cy D. Fect"   4   1)
   (make-subject '24:06   "Dead White Male Thought"                 "Staff"        5   2)
   (make-subject '17:270  "Effective Use of Street Money"           "E. Rollins"   6   3)
   (make-subject '21H:630 "Vital First Amendment Issues"            "S. Rushdie"   4   5)
   ))

(define catalog)

(define studs)

(define (init open-spaces)
  (set! catalog (make-catalog))
  (set! catalog-preferences (make-catalog-preferences))
  (let ((total-spaces (apply + (map subject-capacity catalog))))
    (set! studs (generate-students (- total-spaces open-spaces))))
  'done)

(define (make-catalog-preferences)
  (apply append
	 (map (lambda (subject)
		(make-list (subject-popularity subject)
			   (subject-number subject)))
	      catalog)))

(define catalog-preferences)

;;; For a student we need a preference list:

(define (make-preference-list n)
  (let ((n-prefs (length catalog-preferences)))
    (define (add-another-preference count prefs)
      (if (= count 0)
	  (reverse prefs)
	  (let ((choice (list-ref catalog-preferences
				  (random n-prefs))))
	    (if (memq choice prefs)
		(add-another-preference count prefs)
		(add-another-preference (- count 1) (cons choice prefs))))))
    (add-another-preference n '())))

(define (generate-students n)
  (define (make-names count names-so-far)
    (if (= count 0)
	names-so-far
	(let ((new-name (pick-name)))
	  (if (member new-name names-so-far)
	      (make-names count names-so-far)
	      (make-names (- count 1)
			  (cons new-name
				names-so-far))))))
  (map (lambda (name)
	 (make-student name (make-preference-list (+ (random 6) 1))))
       (make-names n '())))


;;; partitioner takes an integer N and a list L as arguments
;;; returns a list of two parts:
;;; (1) a list of up to N elements chosen from L
;;; (2) the rest of the elements of L
;;; ASSUMPTION: The elements of L are distinct.

;;; primitive partitioners

(define (first-n n l)
  (cond ((= n 0) (list '() l))
	((null? l) (list '() l))
	(else
	 (let ((result (first-n (- n 1) (cdr l))))
	   (let ((chosen (car result))
		 (remainder (cadr result)))
	     (list (cons (car l) chosen)
		   remainder))))))


(define (random-n n l)
  (define (lp count chosen rest len)
    (cond ((= count 0) (list chosen rest))
	  ((null? rest) (list chosen rest))
	  (else
	   (let ((choice
		  (list-ref rest
			    (random len)))) 
	     (let ((nrest (delete choice rest)))
	       (lp (- count 1)
		   (cons choice chosen)
		   nrest
		   (- len 1)))))))
    (lp n '() l (length l)))

(define ((ordered-n <) n l)
  (first-n n (sort l <)))


(define (supplement-with partitioner1 partitioner2)
  (lambda (n l)
    (let ((result1 (partitioner1 n l)))
      (let ((chosen1 (car result1))
	    (remainder1 (cadr result1)))
	(if (= (length chosen1) n)
	    (list chosen1 remainder)
	    (let ((result2
		   (partitioner2 (- n (length chosen1))
			     remainder1)))
	      (let ((chosen2 (car result2))
		    (remainder2 (cadr result2)))
		(list (append chosen1 chosen2)
		      remainder2))))))))

		
;;; pred --> (partitioner --> partitioner)
(define (restrict pred partitioner)
  (lambda (n l)
    (split pred
           l
           (lambda (passed rejected)
             (let ((result (partitioner n passed)))
               (let ((chosen (car result))
                     (remainder (cadr result)))
                 (list chosen (append remainder rejected))))))))

(define (split pred list receiver)
  ;;receiver = (lambda (passed rejected) ...)
  (cond ((null? list) (receiver '() '()))
	((pred (car list))
	 (split
	  pred
	  (cdr list)
	  (lambda (passed rejected)
	    (receiver (cons (car list) passed)
		  rejected))))
	(else
	 (split
	  pred
	  (cdr list)
	  (lambda (passed rejected)
	    (receiver passed
		      (cons (car list) rejected)))))))


;;;; Generate ranodm names, based on the AI lab telephone list

(define last-names
  '("Abelson"     "Adams"         "Alter"        "Alvelda"       "Atkeson"    "Bachelder"
    "Baggett"     "Baker"         "Berlin"       "Berwick"       "Beymer"     "Bisbee"
    "Blair"       "Bohlke"        "Bolotski"     "Borchardt"     "Brock"      "Bromley"
    "Brooks"      "Bryant"        "Bryson"       "Carter"        "Cha"        "Chang"
    "Chong"       "Christian"     "Coen"         "Connell"       "Dally"      "Darling"
    "Davis"       "Davis"         "de Asla"      "de Hon"        "de la Maza" "de Marcken"
    "Dennison"    "Drenckhahn"    "Dron"         "Eberman"       "Ettinger"   "Ferrell"
    "Feynman"     "Fillo"         "Fiske"        "Flynn"         "Freedman"   "Galperin"
    "Gavin"       "Girosi"        "Givan"        "Goulette"      "Greenspun"  "Griesser"
    "Grimson"     "Hanson"        "Herman"       "Hewitt"        "Highleyman" "Horn"
    "Horswill"    "Horwat"        "Hung"         "Hurwitz"       "Hutchinson" "Ida"
    "Irie"        "Isbell"        "Jones"        "Jones"         "Kan"        "Kaneshiro"
    "Kapogiannis" "Kapur"         "Katz"         "Keckler"       "Keen"       "Klanderman"
    "Knight"      "Knobe"         "Koile"        "Koniaris"      "Kozierok"   "Lackritz"
    "LaFrance"    "Ratan"         "LaMacchia"    "Lamb"          "Lathrop"    "Lee"
    "Lee"         "Lee"           "Lee"          "Lethin"        "Leveroni"   "Levow"
    "Lines"       "Lipson"        "Lozano-Perez" "Madhani"       "Mallery"    "Manning"
    "Marjanovic"  "Marill"        "Maron"        "Mataric"       "Matsuoka"   "McAllester"
    "McDonald"    "McClanahan"    "Meila"        "Melithoniotes" "Mellor"     "Meyer"
    "Miller"      "Minsky"        "Minsky"       "Mitra"         "Moore"      "Morrell"
    "Nagao"       "Narasimhan"    "Nastov"       "Ng"            "Nielsen"    "Niyogi"
    "Noakes"      "Nomura"        "Nuth"         "O'Donnell"     "Oh"         "Papadakis"
    "Parker"      "Pfluger"       "Playter"      "Poggio"        "Pollard"    "Raibert"
    "Rao"         "Reed"          "Rees"         "Richter"       "Ringrose"   "Robles"
    "Rodriguez"   "Rogers"        "Romano"       "Rozas"         "Ruecker"    "Salisbury"
    "Sampson"     "Sarachik"      "Sardegna"     "Schaal"        "Schonfeld"  "Seering"
    "Seidel"      "Shashua"       "Shrobe"       "Siapas"        "Simmons"    "Simon"
    "Sinha"       "Skordos"       "Sobalvarro"   "Sofge"         "Spertus"    "Stahovich"
    "Stallman"    "Stein"         "Stein"        "Subirana"      "Sung"       "Surati"
    "Sussman"     "Swarup"        "Tan"          "Taylor"        "Thau"       "Torrance"
    "Tse"         "Turbak"        "Tuttle"       "Ullman"        "Ulrich"     "van Hentenryck"
    "van Zyl"     "Vasilescu"     "Vieri"        "Viola"         "Wallach"    "Walton"
    "Wang"        "Weintraub"     "Wells"        "Wertheimer"    "Wessler"    "White"
    "Wiken"       "Williamson"    "Winston"      "Witty"         "Wong"       "Wu"
    "Wu"          "Wu"            "Xanthopoulos" "Yamamoto"      "Yan"        "Yanco"
    "Younis"      "Yuret"         "Zalondek"     "Zerhouni"      "Zhao"))

(define first-names
  '("Hal"        "Stephen"   "Tao"      "Phillip"          "Chris"     "Ivan"             "David"
    "Jonathan D" "Andrew"    "Bob"      "David"            "Rebecca"   "Michael"          "Kristin"
    "Mike"       "Gary"      "David"    "Gregg"            "Rod"       "Barbara"          "Joanna"
    "Nick"       "John"      "Andrew"   "Fred"             "Andrew"    "Michael H"        "Mike"
    "Bill"       "Jeanne"    "Randy"    "Stephen"          "Michael"   "Andre"            "Michael"
    "Carl"       "Larry"     "Fred"     "Lisa"             "Brian"     "Gil"              "Cynthia"
    "Carl"       "Marco"     "Stuart"   "Anita"            "Lisa"      "Greg"             "Andy"
    "Federico"   "Robert"    "Francois" "Phil"             "Hans"      "Eric L."          "Chris"
    "Bob"        "Carl"      "Liz"      "Berthold"         "Ian"       "Waldemar"         "Elmer"
    "Roger"      "Jim"       "Masayuki" "Robert"           "Charles"   "Doug"             "Mike"
    "Kin Hong"   "Shaun"     "Eleni"    "Tina"             "Boris"     "Steve"            "John"
    "Greg"       "Tom"       "Kathy"    "Kimberle"         "Kleanthes" "Robyn"            "Neal"
    "Kathy"      "Aparna"    "Brian"    "Marie"            "Rick"      "Jintae"           "Lily"
    "Whay Sing"  "Woojin"    "Richard"  "Susanna"          "Gina-Anne" "Stephen"          "Pamela"
    "Tomas"      "Akhil"     "John"     "Carl"             "Matthew"   "Thomas"           "Oded"
    "Maja"       "Yoky"      "David"    "Eric"             "Betty Lou" "Marina"           "Marilyn"
    "J"          "Jonathan"  "James"    "Henry"            "Marvin"    "Neal"             "Jacqueline"
    "John"       "Kenji"     "Sundar"   "Ognen"            "Eileen"    "Eileen"           "Partha"
    "Mike"       "Naoyuki"   "Peter"    "Patrick"          "Jin"       "Nick"             "Lynne"
    "Annika"     "Robert"    "Tommy"    "Nancy"            "Marc"      "Satyajit"         "Chris"
    "Jonathan"   "Sally"     "Robert"   "Jose"             "Luis"      "Keith"            "Raquel"
    "Bill"       "Lukas"     "Ken"      "Michael"          "Karen"     "Lisa"             "Stefan"
    "Ruth"       "Warren"    "Mark"     "Amnon"            "Howard"    "Thanos"           "Laurel"
    "Thomas"     "Pawan"     "Pete"     "Patrick"          "Donald"    "Ellen"            "Tom"
    "Richard"    "Gideon"    "Lynn"     "Brian"            "Kah Kay"   "Rajeev"           "Gerald J"
    "Nitish"     "Yang Meng" "Jacqui"   "Robert"           "Mark"      "Clifford"         "Franklyn"
    "Tim"        "Shimon"    "Karl"     "Pascal"           "Gerrie"    "Manuela"          "Carlin"
    "Paul"       "Deborah"   "Bruce"    "Edward"           "Benjamin"  "Sandy"            "Jeremy"
    "Mike"       "David"     "Ron"      "Matthew"          "Patrick"   "Carl"             "Leon"
    "Alexander"  "Henry"     "Peng"     "Duke"             "Masaki"    "Charles"          "Holly"
    "Saed"       "Deniz"     "Kevin"    "Zakia"            "Feng"))

(define alphabet
  '("A" "B" "C" "D" "E" "F" "G" "H" "I" "J" "K" "L" "M" "N" "O" "P" "Q" "R" "S" "T" "U" "V" "X" "Y" "Z"))


(define (pick-random list)
  (list-ref list (random (length list))))

(define (pick-name)
  (string-append (pick-random first-names)
		 " "
		 (pick-random alphabet)
		 ". "
		 (pick-random last-names)))

