;;; Note! there is one interpretation of no spots, the empty interpretation!

(define (all-interpretations image chart)
  (if (null? image)
      (list the-empty-interpretation)	;here it is!
      (let ((spot-to-match (first image)) (spots (rest image)))
	(define (match-all stars)
	  (if (null? stars)
	      the-empty-list		;There are no interpretations
					;consistent with no stars.
	      (let ((pair (pair-up spot-to-match (car stars))))
		(if (not (consistent-pair? pair))
		    (match-all (cdr stars))
		    (append (extend-interpretations
			     pair
			     (all-interpretations spots
						  (delete (car stars) chart)))
			    (match-all (cdr stars)))))))
	(match-all chart))))

(define (extend-interpretations pair interpretations)
  (define (extend-all interps)
    (cond ((null? interps) the-empty-list)
	  ((ok-to-add? pair (car interps))
	   (cons (augment-interpretation pair (car interps))
		 (extend-all (cdr interps))))
	  (else (extend-all (cdr interps)))))
  (extend-all interpretations))

;;;--------------------------------------------------------------------------

(define the-empty-list '())

(define first car)
(define rest cdr)

(define the-empty-interpretation the-empty-list)
(define augment-interpretation cons)

(define pair-up list)

(define pair-spot car)
(define pair-star cadr)

(define (consistent-pair? p) true)
(define (ok-to-add? p i) true)


(define (consistent-pair? p)
  (<= (abs (- (pair-spot p) (pair-star p))) 1))

(define (ok-to-add? p i)
  (for-all (lambda (p-test)
	     (= (- (pair-spot p) (pair-spot p-test))
		(- (pair-star p) (pair-star p-test))))
	   i))

(define (for-all p? l)
  (let loop ((l l))
    (cond ((null? l) true)
	  ((p? (car l)) (loop (cdr l)))
	  (else false))))


;;; simplified

(define (all-interpretations image chart)
  (if (null? image)
      (list the-empty-interpretation)	;here it is!
      (let ((spot-to-match (first image)) (spots (rest image)))
	(define (match-all stars)
	  (if (null? stars)
	      the-empty-list		;There are no interpretations
					;consistent with no stars.
	      (append (extend-interpretations
		       (pair-up spot-to-match (car stars))
		       (all-interpretations spots
					    (delete (car stars) chart)))
		      (match-all (cdr stars)))))
	(match-all chart))))

(define (extend-interpretations pair interpretations)
  (define (extend-all interps)
    (if (null? interps)
	the-empty-list
	(cons (augment-interpretation pair (car interps))
	      (extend-all (cdr interps)))))
  (extend-all interpretations))







#|
-------------------------------------------------------------------------------

(define all-interpretations
  (lambda (image chart)
    (union
     (mapcar (lambda (star-in-chart)
	       (extend-interptetations
		(pair-up (first image) star-in-chart)
		(all-interpretations (rest image) 
				     (remove star-in-chart chart))))
	     (stars-in chart)))))


(define (extend-interpretations pair interpretations)
  (if (not (pair-consistent? pair)
      '()
      (map (lambda (interp)
	     (augment-interp pair interp))
	   (filter (lambda (interp)
		     (ok-to-add?  pair interp))
		   interpretations)))))



|#
