;; This file is for the Adventure game.

;; Here we define places and  things, as well as providing
;; generally useful procedures. You won't have to modify 
;; any of these procedures, so just load this file into Scheme.

;; A very simple implementation of things

(define (make-thing name)
  (let ((possessor 'no-one))
    (define (object m)
      (cond ((eq? m 'type) 'thing)
	    ((eq? m 'name) name)
	    ((eq? m 'change-possessor)
	     (lambda (new-possessor)
	       (set! possessor new-possessor)))
	    ((eq? m 'possessor) possessor)
	    (else
	     (error "I don't know how to do this -- thing"
		    (list name m)))))

    object  ; return the dispatch procedure
    ))

;; Implementation of places

(define (make-place name)
  (let ((neighbors '()) (things '()))
    (define (here m)
      (cond ((eq? m 'type) 'place)
            ((eq? m 'name) name)
	    ((eq? m 'things) things)
	    ((eq? m 'neighbors)
	     (mapcar cdr neighbors))
	    ((eq? m 'exits)
	     (mapcar car neighbors))

	    ((eq? m 'look-in)
	     (lambda (direction)
	       (let ((p (associate direction neighbors)))
		 (if (null? p) nil (cdr p)))))

	    ((eq? m 'appear)
	     (lambda (new-thing)
	       (if (memq new-thing things)
		   (error "Thing already in this place"
			  (list name new-thing)))
	       (set! things (cons new-thing things))
	       'appeared))

	    ((eq? m 'gone)
	     (lambda (thing)
	       (if (not (memq thing things))
		   (error "Disappearing thing not here"
			  (list name thing)))
	       (set! things (delete thing things))
	       'disappeared))

	    ((eq? m 'new-neighbor)
	     (lambda (direction new-neighbor)
	       (if (associate direction neighbors)
		   (error "Direction already assigned a neighbor"
			  (list name direction)))
	       (set! neighbors
		     (cons (cons direction new-neighbor)
			   neighbors))
	       'connected))

	    (else
	     (error "I don't know how to do this -- place"
		    (list name m)))))
    here         ; return the dispatch procedure
    ))    ;end of MAKE-PLACE procedure

;; The procedure for defining people is in the other file, since
;; we may need to modify it.


;; Some generally useful procedures

(define (announce-move name old-place new-place)
  (newline)
  (princ name)
  (princ " moved from ")
  (princ (old-place 'name))
  (princ " to ")
  (princ (new-place 'name)))

(define (have-fit p)
  (newline)
  (princ "Yaaaah! ")
  (princ (p 'name))
  (princ " is upset!"))

(define (random-place old-place)
  (let ((places (old-place 'neighbors)))
    (if (null? places)
	nil
	(nth (random (length places)) places))))


(define (forall set f)
  (cond ((null? set) nil)
	(else (f (car set))
	      (forall (cdr set) f))))

(define (filter set f)
  (cond ((null? set) '())
	((f (car set))
	 (cons (car set) (filter (cdr set) f)))
	(else (filter (cdr set) f))))

(define (delete o possessions)
  (let ((answer '()))
    (forall possessions
	    (lambda (elem)
	      (if (not (eq? elem o))
		  (set! answer (cons elem answer)))))
    answer))

(define (person? el)
  (eq? (el 'type) 'person))

(define (thing? el)
  (eq? (el 'type) 'thing))

(define (associate label pairs)
  (cond ((null? pairs) nil)
	((eq? label (caar pairs)) (car pairs))
	(else (associate label (cdr pairs)))))


;;Finally, we define the clock that will control our world:

(define (clock)
   (forall queue move))

(define (move person)
  (person 'move))
