;;;This is the second code file for the series-parallel circuit problem set
;;;It contains the improved version of the series-parallel cuircuit
;;;program, which handles capacitors and inductors

;;; Primitive electrical elements.

(define (make-resistor resistance)
  (let ((r (make-complex resistance 0)))
    (attach-type 'resistor
                 (list (list 'resistance resistance)    ;for documentation
                       (lambda (s) r)))))

(define (resistance-resistor resistor)
  (cadr (contents resistor)))

(define (conductance-resistor resistor)
  (lambda (s) (recip ((resistance-resistor resistor) s))))


(define (make-capacitor capacitance)
  (let ((c (make-complex capacitance 0)))
    (attach-type 'resistor
                 (list (list 'capacitance capacitance)
                       (lambda (s)
                         (recip (*c c s)))))))

(define (make-inductor inductance)
  (let ((l (make-complex inductance 0)))
    (attach-type 'resistor
                 (list (list 'inductance inductance)
                       (lambda (s) (*c l s))))))


;;; Compound electrical elements
;;; The constructors and selectors are the same as in ps4-res

(define (make-series ckt1 ckt2)
  (attach-type 'series-combination (list ckt1 ckt2)))

(define (make-parallel ckt1 ckt2)
  (attach-type 'parallel-combination (list ckt1 ckt2)))

(define (left-branch ckt)
  (if (is-type? ckt '(series-combination parallel-combination))
      (car (contents ckt))
      (error "Circuit " ckt " has no LEFT-BRANCH.")))

(define (right-branch ckt)
  (if (is-type? ckt '(series-combination parallel-combination))
      (cadr (contents ckt))
      (error "Circuit " ckt " has no RIGHT-BRANCH.")))


;;These are similar to ps4-res, except for the use of complex-number
;;arithmetic 

(define (conductance-parallel ckt)
  (lambda (s)
    (+c ((conductance (left-branch ckt)) s)
        ((conductance (right-branch ckt)) s))))

(define (conductance-series ckt)
  (lambda (s)
    (recip ((resistance ckt) s))))

(define (resistance-series ckt)
  (lambda (s)
    (+c ((resistance (left-branch ckt)) s)
        ((resistance (right-branch ckt)) s))))

(define (resistance-parallel ckt)
  (lambda (s)
    (recip ((conductance ckt) s))))


;;; Generic operations.
;;; same as ps4-res

(define (conductance ckt)
  (cond ((is-type? ckt '(resistor))
         (conductance-resistor ckt))
        ((is-type? ckt '(parallel-combination))
         (conductance-parallel ckt))
        ((is-type? ckt '(series-combination))
         (conductance-series ckt))
        (else
         (error "Unknown circuit type -- CONDUCTANCE" ckt))))

(define (resistance ckt)
  (cond ((is-type? ckt '(resistor))
         (resistance-resistor ckt))
        ((is-type? ckt '(parallel-combination))
         (resistance-parallel ckt))
        ((is-type? ckt '(series-combination))
         (resistance-series ckt))
        (else
         (error "Unknown circuit type -- RESISTANCE" ckt))))


;;;complex number arithmetic

(define (+c z1 z2)
  (make-complex (+ (real-part z1) (real-part z2))
                (+ (imag-part z1) (imag-part z2))))

(define (*c z1 z2)
  (make-complex (- (* (real-part z1) (real-part z2))
                   (* (imag-part z1) (imag-part z2)))
                (+ (* (real-part z1) (imag-part z2))
                   (* (imag-part z1) (real-part z2)))))

(define (recip z)
  (define very-small-number 1.0e-30)   ;e indicates exponential notation
  (define very-big-number 1.0e+30)
  (let ((magsq (+ (square (real-part z)) (square (imag-part z)))))
    (if (< magsq very-small-number)     ;To prevent division by zero.
        (make-complex very-big-number 0)
        (make-complex (/ (real-part z) magsq)
                      (/ (- (imag-part z)) magsq)))))


(define (make-complex r i) (cons r i))
(define (real-part z) (car z))
(define (imag-part z) (cdr z))


(define (magnitude z)
  (sqrt (+ (square (real-part z)) (square (imag-part z)))))


(define (angle z)
  (atan (imag-part z) (real-part z)))


(define (square x) (* x x))



;;; Type system for analysis tools
;;; same as in ps4-res

(define (attach-type type contents)
  (cons type contents))

(define (type datum)
  (if (not (atom? datum))
      (car datum)
      (error "Bad typed datum -- TYPE" datum)))

(define (contents datum)
  (if (not (atom? datum))
      (cdr datum)
      (error "Bad typed datum -- CONTENTS" datum)))

(define (is-type? datum list-of-types)
  (memq (type datum) list-of-types))
