;;
;; This is the file <ls.source>ps6-2.scm
;;

;;
;; This file defines our imaginary world
;;

;; Here we initialize the queue of people in our world and define several
;; useful related procedures.

(define queue '())

(define (enqueue person)
  (set! queue (cons person queue)))

(define (unqueue person)
  (set! queue (delete person queue)))


;; Here we define the places in our world

(define Bldg-36 (make-place 'Bldg-36))
(define wms-office (make-place 'wms-office))
(define hal-office (make-place 'hal-office))
(define computer-lab (make-place 'computer-lab))
(define EGG-Atrium (make-place 'EGG-Atrium))
(define Bldg-10 (make-place 'Bldg-10))
(define dormitory (make-place 'dormitory))
(define heaven (make-place 'heaven))
(define dungeon (make-place 'dungeon))
(define dean-office (make-place 'dean-office))
(define snack-bar (make-place 'snack-bar))

;; The world is connected together by an accessibility function.
;; The accessibility function is constructed from (one-way!) paths
;; connecting individual places.

(define (can-go from direction to)
  ((from 'new-neighbor) direction to))

(can-go Bldg-36 'up computer-lab)
(can-go Bldg-36 'north hal-office)
(can-go Bldg-36 'west EGG-Atrium)
(can-go hal-office 'south Bldg-36)
(can-go computer-lab 'down Bldg-36)
(can-go wms-office 'down computer-lab)
(can-go dormitory 'east Bldg-10)
(can-go Bldg-10 'west dormitory)
(can-go EGG-Atrium 'up wms-office)
(can-go dungeon 'up EGG-Atrium)
(can-go Bldg-10 'east snack-bar)
(can-go snack-bar 'west Bldg-36)
(can-go Bldg-10 'north EGG-Atrium)
(can-go EGG-Atrium 'south Bldg-10)
(can-go dean-office 'west dormitory)
(can-go dean-office 'down Bldg-10)
(can-go EGG-Atrium 'east Bldg-36)

;; We define persons as follows:

(define wms (make-person 'wms wms-office 1))
(define hal (make-person 'hal hal-office 2))
(define bill (make-person 'bill dormitory 100))

;; We place the HOMEWORK in DORMITORY and the
;; BEER and PIZZA in the SNACK-BAR:

(define homework (make-thing 'homework))
((dormitory 'appear) homework)

(define pizza (make-thing 'pizza))
((snack-bar 'appear) pizza)

(define beer (make-thing 'beer))
((snack-bar 'appear) beer)

;;
;;Here we define a TROLL and a DEAN
;;

(define (make-troll place threshold)
  (let ((hunger 0) (possessions '()))
    (define (me m)
      (cond ((eq? m 'type) 'person)
	    ((eq? m 'name) 'troll)
	    ((eq? m 'place) place)
	    ((eq? m 'possessions) possessions)
	    ((eq? m 'current-position)
	     (newline)
	     (princ (place 'name)))
	    ((eq? m 'move)
	     (set! hunger (1+ hunger))
	     (if (> hunger threshold)
		 (if (other-persons-at-place place)
		     (eat-person (other-persons-at-place place))
		     (let ((new-place (random-place place)))
		       (if new-place (move-to new-place))))))
	    (else
	     (error "I don't know how to do this -- troll" m))))

    (define (other-persons-at-place place)
      (delete me
	      (filter (place 'things) 'person)))

    (define (eat-person persons)
      (let ((selected-person
	     (nth (random (length persons)) persons)))
	(newline)
	(princ "TROLL says - Hssss--s! I'm going to eat you, ")
	(princ (selected-person 'name))
	(princ "!!")
	(if (memq pizza (selected-person 'possessions))
	    (sequence
	     (newline)
	     (princ (selected-person 'name))
	     (princ " says - Take this pizza instead, please!")
	     (newline)
	     (princ "TROLL says - OK, thanks! - and ")
	     (princ "returns to DUNGEON")
	     ((selected-person 'lose) pizza)
	     ((place 'gone) pizza))
	    (sequence
	     (newline)
	     (princ "Aarrr--gh!")
	     (newline)
	     (princ "TROLL eats ")
	     (princ (selected-person 'name))
	     (princ ", belches, and returns to DUNGEON")
	     (unqueue selected-person)
	     (selected-person 'go-to-heaven)))
	(set! hunger 0)
	((place 'gone) me)
	((dungeon 'appear) me)
	(set! place dungeon)
	nil))

    (define (move-to new-place)
      (newline)
      (princ "TROLL moved from ")
      (princ (place 'name))
      (princ " to ")
      (princ (new-place 'name))
      ((place 'gone) me)
      ((new-place 'appear) me)
      (set! place new-place)
      (if (other-persons-at-place new-place)
	  (eat-person (other-persons-at-place new-place))))
    
    ((place 'appear) me)
    me))



(define (make-dean place threshold)
  (let ((officiousness 0)
	(possessions '()))
    (define (me m)
      (cond ((eq? m 'type) 'person)
	    ((eq? m 'go-to-heaven)
	     ((place 'gone) me)
	     ((heaven 'appear) me)
	     (set! place heaven))
	    ((eq? m 'name) 'dean)
	    ((eq? m 'place) place)
	    ((eq? m 'possessions) possessions)
	    ((eq? m 'current-position)
	     (newline)
	     (princ (place 'name)))
	    ((eq? m 'move)
	     (set! officiousness
		   (1+ officiousness))
	     (if (> officiousness threshold)
		 (if (who-has-beer place)
		     (smash-beer place)
		     (let ((new-place (random-place place)))
		       (if new-place (move-to new-place))))))
	    (else
	     (error "I don't know how to do this -- dean" m))))

    (define (who-has-beer place)
      (define (beer-test people-list)
	(cond ((null? people-list) nil)
	      ((memq beer ((car people-list) 'possessions))
	       (cons (car people-list)
		     (beer-test (cdr people-list))))
	      (else (beer-test (cdr people-list)))))
      (beer-test (filter (place 'things) 'person)))

    (define (smash-beer this-place)
      (newline)
      (princ "DEAN says - Ah-HAH! Caught you!!")
      (newline)
      (princ "I do not approve of beer on campus!")
      (newline)
      (princ "DEAN smashes beer and returns")
      (newline)
      (princ "to DEAN-OFFICE")
      (forall
       (who-has-beer this-place)
       (lambda(p)
	      ((p 'lose) beer)
	      (have-fit p)
	      ((this-place 'gone) beer)))
      (set! officiousness 0)
      ((this-place 'gone) me)
      ((dean-office 'appear) me)
      (set! place dean-office)
      nil)

    (define (move-to new-place)
      (newline)
      (princ "DEAN moved from ")
      (princ (place 'name))
      (princ " to ")
      (princ (new-place 'name))
      ((place 'gone) me)
      ((new-place 'appear) me)
      (set! place new-place)
      (if (who-has-beer place)
	  (smash-beer place)))

    ((place 'appear) me)
    me))

(define troll (make-troll dungeon 3))
(define dean (make-dean dean-office 3))

;;
;;Finally, we define the clock that will control our world:
;;

(define (clock)
   (forall queue move)
   (move dean)
   (move troll))

(define (move person)
  (person 'move))    