;;; Copyright (c) 1990 Massachusetts Institute of Technology
;;; 
;;; This material was developed by the Scheme project at the Massachusetts
;;; Institute of Technology, Department of Electrical Engineering and
;;; Computer Science.  Permission to copy this material, to redistribute
;;; it, and to use it for any non-commercial purpose is granted, subject
;;; to the following restrictions and understandings.
;;; 
;;; 1. Any copy made of this material must include this copyright notice
;;; in full.
;;; 
;;; 2. Users of this material agree to make their best efforts (a) to
;;; return to the MIT Scheme project any improvements or extensions that
;;; they make, so that these may be included in future releases; and (b)
;;; to inform MIT of noteworthy uses of this material.
;;; 
;;; 3. All materials developed as a consequence of the use of this
;;; material shall duly acknowledge such use, in accordance with the usual
;;; standards of acknowledging credit in academic research.
;;; 
;;; 4. MIT has made no warrantee or representation that this material
;;; (including the operation of software contained therein) will be
;;; error-free, and MIT is under no obligation to provide any services, by
;;; way of maintenance, update, or otherwise.
;;; 
;;; 5. In conjunction with products arising from the use of this material,
;;; there shall be no use of the name of the Massachusetts Institute of
;;; Technology nor of any adaptation thereof in any advertising,
;;; promotional, or sales literature without prior written consent from
;;; MIT in each case. 

;;; This is the code for problem set 2

;;; Written by Ruth Shyu

;;; 6/6/89
;;; Cleaned up by Lyn 

;;; This is the answer to Ex. 1.11 for you to work on Ex. 1.13

(define (new-exp b n)
  (define (square x) (* x x))
  (define (iter-exp multiplier product exponent)
    (cond ((= exponent 0) product)
          ((even? exponent)
           (iter-exp (square multiplier) product (/ exponent 2)))
          (else (iter-exp multiplier
                          (* product multiplier)
                          (- exponent 1)))))
  (iter-exp b 1 n))

;;; Procedures needed to implement fermat's test of primality

(define square (lambda (x) (* x x)))

(define big-random
  (lambda (n)
    (random (min n (expt 10 10)))))

(define fermat-test
  (lambda (n)
    (let ((a (big-random n)))
      (= (expmod-3 a n n) a))))

(define fast-prime?
  (lambda (n times)
    (if (= times 0)
	#t
	(and (fermat-test n)
	     (fast-prime? n (- times 1))))))

;;; Louis Reasoner's 3 versions of expmod

(define expmod-1
  (lambda (b e m)
    (cond ((= e 0) 1)
          (else (remainder (* b
                              (expmod-1 b (-1+ e) m))
                           m)))))

(define expmod-2
  (lambda (b e m)
    (define exp-helper
      (lambda (times)
        (cond ((= times 0) 1)
              ((even? times)
               (square (exp-helper (\ times 2))))
              (else (* b (exp-helper (-1+ times)))))))
  (remainder (exp-helper e) m)))

(define expmod-3
  (lambda (b e m)
    (cond ((= e 0) 1)
          ((even? e)
           (remainder (square (expmod-3 b (/ e 2) m))
                      m))
          (else
           (remainder (* b (expmod-3 b (-1+ e) m))
                      m)))))

(define timed-exp
  (lambda (f b e m)
    (let ((start-time (runtime)))
      (let ((result (f b e m)))
	(newline)
	(princ "TIMED-EXP: ")
	(princ (- (runtime) start-time))
	result))))




;;; CIA's key selection procedures

;;; SELECT-PRIME randomly generates a prime via the formula
;;; N^2 + N + 41.  This formula happens to be prime 
;;; for all 0 <= N < 40.  The test for FAST-PRIME?
;;; is included for cases where the upper bound on 
;;; N is raised to 40 or above.

(define select-prime
  (lambda ()
    (let ((n (random 20)))
      (if (<= n 1)
          (select-prime)
          (let ((p (+ (square n) n 41)))
            (if (fast-prime? p 2)
                p
                (select-prime)))))))

(define select-keys
  (lambda ()
    (print "Please wait for your daily lottery numbers........")
    (let ((start-time (runtime)))
      (let ((p (select-prime))
	    (q (select-prime)))
	(if (= p q)
	    (select-keys)
	    (sequence
	      (print "Your first public key is ..... ")
	      (print (* p q))
	      (print "Your second public key is .....")
	      (print (select-e (* (- p 1) (- q 1))))
	      (print "The elapsed time is")
	      (print (- (runtime) start-time))))))))

(define select-e
  (lambda (m)
    (let ((e (random 1000)))
      (if (= (gcd e m) 1)
          e
          (select-e m)))))

(define gcd
  (lambda (a b)
    (if (= b 0)
        a
        (gcd b (remainder a b)))))


;;; Encryption and Decryption procedures (really simple)


(define encrypt
  (lambda (message e n)
    (expmod-3 message e n)))

(define decrypt
  (lambda (message d n)
    (expmod-3 message d n)))


;;; Part of KGB's Ordr O. Grofiev and Bloch Schtraktur's Code-cracker


(define (improve guess)
  (- guess 1))

;;; The rest is for you to complete.
