;;; Copyright (c) 1990 Massachusetts Institute of Technology
;;; 
;;; This material was developed by the Scheme project at the Massachusetts
;;; Institute of Technology, Department of Electrical Engineering and
;;; Computer Science.  Permission to copy this material, to redistribute
;;; it, and to use it for any non-commercial purpose is granted, subject
;;; to the following restrictions and understandings.
;;; 
;;; 1. Any copy made of this material must include this copyright notice
;;; in full.
;;; 
;;; 2. Users of this material agree to make their best efforts (a) to
;;; return to the MIT Scheme project any improvements or extensions that
;;; they make, so that these may be included in future releases; and (b)
;;; to inform MIT of noteworthy uses of this material.
;;; 
;;; 3. All materials developed as a consequence of the use of this
;;; material shall duly acknowledge such use, in accordance with the usual
;;; standards of acknowledging credit in academic research.
;;; 
;;; 4. MIT has made no warrantee or representation that this material
;;; (including the operation of software contained therein) will be
;;; error-free, and MIT is under no obligation to provide any services, by
;;; way of maintenance, update, or otherwise.
;;; 
;;; 5. In conjunction with products arising from the use of this material,
;;; there shall be no use of the name of the Massachusetts Institute of
;;; Technology nor of any adaptation thereof in any advertising,
;;; promotional, or sales literature without prior written consent from
;;; MIT in each case. 


;;;  These procedures are included in PS9-ANSWER.SCM, and will be needed
;;;  in problem 4.  The first is a modified version of user-print which 
;;;  calls the procedures you will be implementing.  It's old version
;;;  is included in the PS9-ECEVAL.SCM code.

(define (user-print object)
  (cond ((compound-procedure? object)
         (print (list 'compound-procedure
                      (parameters object)
		      (procedure-body object)
                      '[procedure-env])))
        ((compiled-procedure? object)
         (print '[compiled-procedure]))
; the following three lines will be used when tracing is added
        ((traced-procedure? object)			
         (print 'traced-procedure)
         (user-print (procedure-part-traced object)))
        (else (print object))))

;;;  This procedure will be helpful in actually printing the tracing 
;;;  information.

(define (print-call fun-name arglist)
	(print (list 'calling 
		     'procedure
		     fun-name
		     'with 
		     (reverse arglist))))       ; arguments stored in reverse

