;;; Copyright (c) 1990 Massachusetts Institute of Technology
;;; 
;;; This material was developed by the Scheme project at the Massachusetts
;;; Institute of Technology, Department of Electrical Engineering and
;;; Computer Science.  Permission to copy this material, to redistribute
;;; it, and to use it for any non-commercial purpose is granted, subject
;;; to the following restrictions and understandings.
;;; 
;;; 1. Any copy made of this material must include this copyright notice
;;; in full.
;;; 
;;; 2. Users of this material agree to make their best efforts (a) to
;;; return to the MIT Scheme project any improvements or extensions that
;;; they make, so that these may be included in future releases; and (b)
;;; to inform MIT of noteworthy uses of this material.
;;; 
;;; 3. All materials developed as a consequence of the use of this
;;; material shall duly acknowledge such use, in accordance with the usual
;;; standards of acknowledging credit in academic research.
;;; 
;;; 4. MIT has made no warrantee or representation that this material
;;; (including the operation of software contained therein) will be
;;; error-free, and MIT is under no obligation to provide any services, by
;;; way of maintenance, update, or otherwise.
;;; 
;;; 5. In conjunction with products arising from the use of this material,
;;; there shall be no use of the name of the Massachusetts Institute of
;;; Technology nor of any adaptation thereof in any advertising,
;;; promotional, or sales literature without prior written consent from
;;; MIT in each case. 

;;;This is the code for the Doctor problem set

(define (visit-doctor name)
  (print (list 'hello, name))
  (print '(what seems to be the trouble?))
  (doctor-driver-loop name))

(define (doctor-driver-loop name)
  (newline)
  (princ '**)
  (let ((user-response (read)))
    (cond ((equal? user-response '(goodbye))
	   (print (list 'goodbye, name))
	   (print '(see you next week)))
	  (else (print (reply user-response))
		(doctor-driver-loop name)))))

(define (reply user-response)
  (cond ((fifty-fifty)
	 (append (qualifier)
		 (change-person user-response)))
	(else (hedge))))

(define (fifty-fifty)
  (= (random 2) 0))

(define (qualifier)
  (pick-random '((you seem to think)
		 (you feel that)
		 (why do you believe)
		 (why do you say))))

(define (hedge)
  (pick-random '((please go on)
		 (many people have the same sorts of feelings)
		 (many of my patients have told me the same thing)
		 (please continue))))

(define (replace pattern replacement lst)
  (cond ((null? lst) '())
	((equal? (car lst) pattern)
	 (cons replacement
	       (replace pattern replacement (cdr lst))))
	(else (cons (car lst)
		 (replace pattern replacement (cdr lst))))))

(define (many-replace replacement-pairs lst)
  (cond ((null? replacement-pairs) lst)
        (else (let ((pat-rep (car replacement-pairs)))
		(replace (car pat-rep)
			 (cadr pat-rep)
			 (many-replace (cdr replacement-pairs)
				       lst))))))

(define (change-person phrase)
  (many-replace '((i you) (me you) (am are) (my your))
		phrase))

(define (pick-random lst)
  (nth (random (length lst)) lst))

(define (prob n1 n2)
  (< (random n2) n1))

(define (ask-patient-name)
  (print '(next!))
  (print '(who are you?))
  (car (read)))
