;; -*- Scheme -*-
;;
;; $Id: mawk01.scm,v 1.4 1993/10/31 16:44:51 bevan Exp $

(require 'read-line)

;;+doc
;; procedure: mawk:for-all!
;; arguments: action[line line-number]
;; signature: (string x int -> unspecified) -> unspecified
;; arguments: action[line line-number] port
;; signature: (string x int -> unspecified) x port -> unspecified
;; pre:       (input-port? port)
;;
;; Applies ACTION to each line read from PORT or from (CURRENT-INPUT-PORT)
;; if PORT is not defined.  The second argument to ACTION is the line
;; number of that line (starts at 1).
;;
;; > (mawk:for-all!
;;     (lambda (l ln)
;;       (display ln) (display " ") (display l) (newline)))
;;
;; This prints out the (CURENT-INPUT-PORT) line by line with the line
;; number at the start of the line.  This is, therefore a naive version
;; of BSD "cat -n" or SYS V "nl" 
;;-doc

(define mawk:for-all!
  (lambda (a . opt)
    (let ((ip (if (null? opt) (current-input-port) (car opt))))
      (let loop ((l (read-line ip)) (ln 1))
	(if (eof-object? l)
	    l				; arbitrary
	    (begin (a l ln) (loop (read-line ip) (+ ln 1))))))))

;; eof
