; $Header: sem2.s,v 1.5 84/10/26 15:32:40 mw Exp $

; Example of use of type-checker and syntax-directed transducer

; A Language with Statements

; ************************************************************
; $Log:	sem2.s,v $
;;; Tue Apr 11 14:45:50 1989 mw
;;; Revised for LL version of grammar, Chez scheme version of SPS

; Revision 1.5  84/10/26  15:32:40  mw
; Cleaned up semantics a little, rearranged and tidied.
; 
; Revision 1.4  84/02/27  13:21:26  mw
; Added notzerop, pr4 example
; 
; Revision 1.3  84/02/16  09:53:13  mw
; comments on grammar modified to match yacc grammar
; 
; Revision 1.2  84/01/27  14:48:44  mw
; Updated to use new define-type-constructor
; 
; ************************************************************

; define types for various domains

(define-type-abbrev value int)
(define-type-abbrev state (state))	; to be defined later
(define-type-abbrev lvalue (lvalue))	; to be defined later
(define-type-abbrev ans bool)

(define-type-abbrev ccont (-> (seq state) ans))
(define-type-abbrev expcont (-> (seq value) ccont))
(define-type-abbrev env (-> (seq symbol) (union (lvalue) (triv))))
(define-type-abbrev bcont (-> (seq bool) ccont))
(define-type-abbrev lcont (-> (seq (lvalue)) ccont))
(define-type-abbrev dcont (-> (seq env) ccont))

; Typenames beginning with capital letters are associated by
; convention with nonterminals.

(define-type-abbrev Pgm (-> (seq (list int)) ans))
(define-type-abbrev Cmd (-> (seq env ccont) ccont))
(define-type-abbrev Cmdlist Cmd)
(define-type-abbrev Block Cmd)
(define-type-abbrev Dcl (-> (seq env dcont) ccont))
(define-type-abbrev Dcllist Dcl)
(define-type-abbrev Rhs (-> (seq env expcont) ccont))
(define-type-abbrev Lhs (-> (seq env lcont) ccont))
(define-type-abbrev Boolexp (-> (seq env bcont) ccont))
(define-type-abbrev Ident (-> (seq env lcont) ccont))

; definitions of assorted auxiliary functions

(define-checked terminate
  (generic (x) (-> (seq x) ccont))
   (lambda (msg)
      (lambda (state-token)
	 (begin
	    (print msg)
	    (newline)))))

(define-checked terminate-normally
   ccont
   (terminate  (list 'terminate-normally)))

; now define a type (lvalue) with a hidden representation.
; define-type-constructor can also be used to define generic type
; constructors, e.g. (a-list x).

(define-type-constructor (lvalue)
   (pair symbol value)		; the representation.  We are going to use
				; set-car!, so we can't use union.
   (lval$new      		; the nil is the list of local generic type
				; variables.
      (-> (seq) (lvalue))	; lval$new is a function of no args,
			        ; returning an lvalue.
      (lambda ()
	 (enc (pair 'uninitialized any))))
   (lval$contents 
      (-> (seq expcont (lvalue)) ccont)
      (lambda (k loc)
	 (lambda (state)	; here the state token is used for
				; synchronization
	    (if (eq? (lson (dec loc)) 'uninitialized)
		((terminate 
		    (list '|can't-take-contents-of-uninitialized vble|))
		 state)
		((k (rson (dec loc)))
		 state)))))
   (assign 
      (-> (seq ccont (lvalue)) expcont)
      (lambda (kc loc)
	 (lambda (v)
	    (lambda (state)
	       (begin 
		  (set-car! (dec loc) 'initialized)
		  (set-cdr! (dec loc) v)
		  (kc state)))))))

; since lvalues are so sophisticated, we can
; define (state) simply.  We use an unforgeable token which we pass around
; for synchronization, a list to represent the input state, and we use real
; output to represent output.

(define-type-constructor (state)
   symbol
   (the-state-token (state) (enc 'the-state-token)))

(define-checked the-input (list int) any)

(define-checked initstate
   (-> (seq (list int)) state)
   (lambda (w)
      (begin
	 (set! the-input w)
	 the-state-token)))

; auxiliary functions for environments

(define-checked initenv
   env
   (lambda (id) (inR triv)))

(define-checked ext
   (-> (seq env symbol lvalue) env)
   (lambda (r id val)
      (lambda (id1)
	 (if (eq? id1 id) (inL val) (r id1)))))

(define-checked declare
   (-> (seq symbol env dcont) ccont)
   (lambda (id r kr) 
      (kr (ext r id (lval$new)))))

; auxiliaries for input/output

(define-checked do-read
   (-> (seq expcont) ccont)
   (lambda (k)
      (lambda (state)
	 (if (null? the-input)
	     ((terminate (list 'eof-error)) state)
	     (let ((next (car the-input)))
		  (begin
		     (set! the-input (cdr the-input))
		     ((k next) state)))))))

(define-checked do-print
   (-> (seq ccont) expcont)
   (lambda (k)
      (lambda (v)
	 (lambda (state)
	    (begin
	       (print v)
	       (newline)
	       (k state))))))

; coercions

(define-checked rv
   (-> (seq expcont) lcont)
   (lambda (k)
      (lambda (loc)
	 (lval$contents k loc))))

(define-checked lv
    (-> (seq lcont) lcont)
    (lambda (kl) kl))

; here is the syntax-directed transduction

(define-grammar sem2 pgm
  (pgm					; pgm ::= block
    (Pgm (Block))			
    (:blk)
    (lambda (w)
      ((:blk initenv terminate-normally)
       (initstate w))))

  (block				; block ::= (decl-list in stmt-list)
    (Block (Dcllist 'in Cmdlist 'end))
    (:dl :sl)	
    (lambda (r k)
      (:dl r (lambda (r1) (:sl r1 k)))))

  (null-decl-s				; decl-list ::= <empty>
    (Dcllist ())
    ()
    (lambda (r kr) (kr r)))

  (decl-list				; decl-list ::= decl decl-list
    (Dcllist (Dcl Dcllist))
    (:dcl :dl)
    (lambda (r kr) (:dcl r (lambda (r1) (:dl r1 kr)))))

  (decl					; decl ::= new symbol
    (Dcl ('new symbol))
    (name)
    (lambda (r kr) (declare name r kr)))

  (null-stmt-list			; stmt-list ::= <empty>
    (Cmdlist ())
    ()
    (lambda (r kc) kc))

  (stmt-list				; stmt-list ::= stmt; stmt-list
    (Cmdlist (Cmd 'semicolon Cmdlist))
    (:s :sl)
    (lambda (r kc) (:s r (:sl r kc))))

  (assign-stmt				; stmt ::= (assign lhs rhs)
    (Cmd ('assign Lhs Rhs))
    (:lhs :rhs)
    (lambda (r kc)
      (:lhs r (lambda (loc) (:rhs r (assign kc loc))))))

  (if-stmt				; stmt ::= (if bool stmt1 stmt2)
    (Cmd ('if Boolexp Cmd Cmd))
    (:bool :s1 :s2)
    (lambda (r kc)
      (:bool r (lambda (b)
		 (if b (:s1 r kc) (:s2 r kc))))))

  (while-stmt				; stmt ::= (while bool stmt)
    (Cmd ('while Boolexp Cmdlist 'end))
    (:bool :cmdlist)
    (lambda (r kc)
      (fix theta
	   (:bool r (lambda (b)
		      (if b (:cmdlist r theta) kc))))))

  (read-stmt				; stmt ::= (read lhs)
    (Cmd ('read Lhs))
    (:lhs)
    (lambda (r kc)
      (:lhs r (lambda (loc)
		(do-read (assign kc loc))))))

  (print-stmt				; stmt ::= (print rhs)
    (Cmd ('print Rhs))
    (:rhs)
    (lambda (r kc)
      (:rhs r (do-print kc))))

  (block-stmt				; stmt ::= block
    (Cmd (Block))
    (:block)
    :block)

  (exp-id				; rhs ::= ident
    (Rhs (Ident))
    (:ident)
    (lambda (r k) 
      (:ident r 
	(lambda (loc)
	  (lval$contents k loc)))))

  (const				; rhs ::= int
    (Rhs (int))
    (c)
    (lambda (r k) (k c)))
 
  (add1					; rhs ::= add1 rhs
    (Rhs ('add1 Rhs))
    (:rhs)
    (lambda (r k) (:rhs r (lambda (v) (k (+ 1 v))))))

  (sub1					; rhs ::= sub1 rhs
    (Rhs ('sub1 Rhs))
    (:rhs)
    (lambda (r k) (:rhs r (lambda (v) (k (+ -1 v))))))

  (zerop				; boolexp ::= zerop rhs
    (Boolexp ('zerop Rhs))
    (:rhs)
    (lambda (r kb) (:rhs r (lambda (v) (kb (zero? v))))))
	     
  (notzerop				; boolexp ::= nzerop rhs
    (Boolexp ('notzerop Rhs))
    (:rhs)
    (lambda (r kb) (:rhs r (lambda (v) (kb (not (zero? v)))))))

  (id					; lhs ::= ident
    (Lhs (Ident))
    (:ident)
    (lambda (r kl) (:ident r (lv kl))))

  (lit-to-id				; id ::= symbol
    (Ident (symbol))
    (name)
    (lambda (r kl)
      (union-case (r name)
	kl
	(lambda (triv) (terminate (list 'undeclared-variable name))))))
     
  )



; two sample programs

(define pr1 "in print 3; end")		; a block with no declarations

(define pr2 "new x in print 3; assign x 4; print x;")

(define test1			; run pr1 on input (1 2 3)
    (lambda ()
	((sem2 pr1) '(1 2 3))))

(define pr3
    "new a new b in assign a 1; assign b 1;
	 read b ; if zerop b
		      in print 0 ; print a; print b; end
		      in print 1; print b; print a; end;
		      end")

(define pr4
   "new x new sum in
       read x;
       print x;
       assign sum 0;
       while notzerop x
	     print sum;
	     assign sum add1 add1 sum;
	     assign x sub1 x;
             end;
       print sum; end")
