;;;             Copyright (C) 1989, by William M. Wells III
;;;                         All Rights Reserved
;;;     Permission is granted for unrestricted non-commercial use.

;;; This file defines functions to compile and load the zebu
;;; parser generating system.  The beginning of this file
;;; should be configured when the system is installed.


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; BEGINNING OF STUFF NEEDING CONFIGURATION
;;; Choose one of the following:
;;;    pc-scheme (from Texas Instruments) 
;;;    c-scheme (from MIT)

(define scheme-implementation 'c-scheme)
;;;(define scheme-implementation 'pc-scheme)

;;; Set this to the directory where the zebu code will live:
(define zebu-directory "/home/ab/sw/scm/zebu/")
;;; (define zebu-directory "\\src\\zebu\\")
 
;;; END OF STUFF NEEDING CONFIGURATION
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (compile-zebu)
  (for-each
    (lambda (file) (file-loader (string-append zebu-directory file)))
    macro-files)
  (for-each 
    (lambda (basename) (file-compiler (string-append zebu-directory basename)))
    file-basenames))


(define (load-zebu)
  (for-each
   (lambda (basename)
     (let ((basepath (string-append zebu-directory basename)))
       (case scheme-implementation
	 ((pc-scheme)
	  (let ((fasl-file (string-append basepath ".fsl")))
	    (if (file-exists? fasl-file)
		(file-loader fasl-file)
		(file-loader (string-append basepath ".so")))))
	 ((c-scheme) (file-loader (string-append basepath ".bin"))))))
   file-basenames))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Internal from here down:

(define zebu-version ".9")



(display "Zebu version ") (display zebu-version) (display " for ")
(display (case scheme-implementation
	   ((pc-scheme) "PC SCHEME")
	   ((c-scheme) "C-SCHEME")))
(newline)


(define macro-files 
  (case scheme-implementation
    ((pc-scheme) '("pc-schem.scm" "macros.scm"))
    ((c-scheme) '("c-scheme.scm" "macros.scm"))))

(define file-basenames
 '("oset" "g-symbol" "loadgram" "item" "closure0" 
          "lr0-sets" "empty-st" "first" "follow" "tables" 
          "slr" "closure1" "lalr1" "dump" "driver"))

(define source-extension ".scm")

(define (file-compiler base-path)
  (let ((source-file (string-append base-path source-extension)))
    (case scheme-implementation
      ((pc-scheme) ; Flush the fasl file if it exists...
       (newline) (display "Compiling ") (display source-file)
       (let ((fasl-file (string-append base-path ".fsl")))
         (if (file-exists? fasl-file) (dos-delete fasl-file)))
       (compile-file source-file (string-append base-path ".so")))
      ((c-scheme) 
       (sf source-file)))))

	 

(define (file-loader name)
  (case scheme-implementation
    ((pc-scheme) (newline) (display "Loading ") (display name)))
  (load name))
  

;;; PC scheme requires a control-Z at the end of each source file: 
