;;;             Copyright (C) 1989, by William M. Wells III
;;;                         All Rights Reserved
;;;     Permission is granted for unrestricted non-commercial use.

(declare (usual-integrations))

;;;
;;; Do all needed to build an slr table starting with a lisp syntax grammar.

(define (slr-tables-from-grammar file-name)
  (load-grammar file-name)
  (calculate-empty-string-derivers)
  (calculate-first-sets)
  (calculate-follow-sets)
  (make-lr0-collection)
  (build-parse-tables #f))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; test:

(comment-out
 (load "slr.scm")
 (slr-tables-from-grammar "ex1.grm")
 (display "symbols: ") (newline)
 (cruise-symbols-2)
 (display "productions: ") (newline)
 (print-productions)
 (display "lr0 item sets: ") (newline)
 (print-collection #f)
 (display "slr tables: ") (newline)
 (cruise-parse-tables)
 )


;;; PC scheme requires a control-Z at the end of each source file: 
