;;;             Copyright (C) 1989, by William M. Wells III
;;;                         All Rights Reserved
;;;     Permission is granted for unrestricted non-commercial use.

;;; Some pc-scheme specific compatibility hacks.

;;; Create a macro defining form analogous to the common lisp
;;; defmacro.  

(macro def-macro 
  (lambda (defining-form)
    `(macro ,(caadr defining-form)
       ,(construct-expander defining-form))))

(define (construct-expander defining-form)
  `(lambda (text-form)
     (let ,(construct-let-list (cdadr defining-form))
       ,(caddr defining-form))))

(define (construct-let-list formals-list)
  (construct-let-list-aux formals-list 1))

(define (construct-let-list-aux remaining-formals position-index)
  (cond ((null? remaining-formals) '())
        ((pair? remaining-formals)
         (cons `(,(car remaining-formals) (list-ref text-form ,position-index))
               (construct-let-list-aux (cdr remaining-formals )
                                       (+ 1 position-index))))
        ;; Else it should be a "rest" symbol
        (else `((,remaining-formals (list-tail text-form ,position-index))))))



;;; Some other random compatibility hacks.  C-scheme doesn't have setf
;;; style set!, so the code uses a set-slot! macro which can be
;;; implemented in either system for mutating structs.
;;; c-scheme define-structure does positional constructors by default
;;; (which pc-scheme can't do) so we couldn't use that name.

(def-macro (define-struct name-etc . rest)
              `(define-structure ,name-etc . ,rest))

(def-macro (set-slot! accessor-form value)
              `(set! ,accessor-form ,value))

;;; The c-scheme eval uses two arguments, so we define an alternative.

(def-macro (one-arg-eval form)
  `(eval ,form))


;;; We will declare things in c-scheme but not in pc-scheme:

(def-macro (declare . forms)
  '())

;;; PC scheme requires a control-Z at the end of each source file: 
