;;;             Copyright (C) 1989, by William M. Wells III
;;;                         All Rights Reserved
;;;     Permission is granted for unrestricted non-commercial use.

(declare (usual-integrations))

;;;
;;; Compute follow on a grammar symbol.

(define (calculate-follow-sets)
  (compute-follow-dependers)
  (follow-insert-first-sets))


(define (compute-follow-dependers)
  (for-each
   (lambda (prod)
     (compute-follow-dependers-aux prod (rhs prod)))
   productions))

;;; Called initially on a production with prod being the production and
;;; prod-cdr being the rhs of the production.
;;; Returns true only if the prod-cdr derives the empty string, or is the
;;; empty string.  fills in follow set dependencies by side effect.

(define (compute-follow-dependers-aux prod prod-cdr)
  (cond
   ((null? prod-cdr) #t)
   ((compute-follow-dependers-aux prod (cdr prod-cdr))
    ;; Then we fix up dependencies...
    (oset-insert! (car prod-cdr)
		  (g-symbol-follow-dependers (lhs prod)))
    ;; Return indication of whether tail derives empty string.
    (g-symbol-derives-empty-string (car prod-cdr))
    )
   (else #f)))

(define (follow-insert-first-sets)
  (follow-insert-symbol the-end-g-symbol start-symbol)
  (for-each (lambda (prod) (follow-insert-first-sets-aux (rhs prod)))
	    productions))


;;; Called on successive tails of the rhs of each production.

(define (follow-insert-first-sets-aux prod-rest)
  (cond ((null? prod-rest) #f)
        ((null? (cdr prod-rest)) #f)
        ;; prod-rest has at least two items
        (else (oset-for-each
	    (lambda (symbol)
	      (if (not (eq? symbol empty-string-g-symbol))
		  (follow-insert-symbol symbol (car prod-rest))))
	    (first-seq (cdr prod-rest)))
           (follow-insert-first-sets-aux (cdr prod-rest)))))

;;; Both arguments are g-symbols.

(define (follow-insert-symbol symbol-to-insert whose-follow-set)
  (if (oset-insert! symbol-to-insert (g-symbol-follow-set whose-follow-set))
      (begin
        ;; Do it to his dependers too..
        (oset-for-each
	 (lambda (depender)
	   (follow-insert-symbol symbol-to-insert depender))
	 (g-symbol-follow-dependers whose-follow-set)))))

(define (print-follow-set x)
  (oset-for-each
   (lambda (ee)
     (display (g-symbol-print-name ee)) (display " "))
   x))

(define (cruise-follow-sets )
  (for-each
   (lambda (sym)
     (newline)
     (display (g-symbol-print-name sym))
     (display " : ")
     (print-follow-set
      (g-symbol-follow-set sym))
     (newline)
     (display "--------------------"))
   symbols))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; test:

(comment-out
 (load "follow")
 (load-grammar "ex2.grm")
 (calculate-empty-string-derivers)
 (calculate-first-sets)
 (calculate-follow-sets)
 (cruise-follow-sets)
 )


;;; PC scheme requires a control-Z at the end of each source file: 
