;;;             Copyright (C) 1989, by William M. Wells III
;;;                         All Rights Reserved
;;;     Permission is granted for unrestricted non-commercial use.

(declare (usual-integrations))

;;;
;;; Cruise the productions and figure out which ones derive the empty string.

(define (calculate-empty-string-derivers)
  (for-each
    (lambda (prod)
      (if
	(null? (rhs prod))
        (process-symbol-which-derives-empty-string (lhs prod))))
    productions))

(define (process-symbol-which-derives-empty-string gs)
  (if (not (g-symbol-derives-empty-string gs))
      (begin
	(print-g-symbol gs) (display " derives the empty string") (newline)
	(set-slot! (g-symbol-derives-empty-string gs) #t)
	(for-each
	 (lambda (prod)
	   (if (string-vanishes (rhs prod))
	       (process-symbol-which-derives-empty-string (lhs prod))))
	 (g-symbol-rhs-productions gs)))))

(define (string-vanishes gslist)
  (cond ((null? gslist) #t)
        ((not (g-symbol-derives-empty-string (car gslist))) #f)
        (else (string-vanishes (cdr gslist)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; test:

(comment-out
 (load "empty-st")
 (load-grammar "ex3.grm")
 (calculate-empty-string-derivers)
 )


;;; PC scheme requires a control-Z at the end of each source file: 
