;;;             Copyright (C) 1989, by William M. Wells III
;;;                         All Rights Reserved
;;;     Permission is granted for unrestricted non-commercial use.

(declare (usual-integrations))

;;;
;;; Calculate the lr(1) closure of a set of lr(1) items.
;;; Currently, find the closure of a set of one lr(1) item.
;;;
;;; An lr(1) item data structure with a set of lookaheads
;;; actually stands for a set of lr(1) items which are the
;;; same except for each having one lookahead from the set.

(define (single-item-closure-1 lr0-item look-ahead)
  (let ((eset (make-oset 'order-fn item-order-function)))
    (closure-1-insert-item! lr0-item look-ahead eset)
    eset))


;;; Destructively take the lr(1) closure of an item set
;;; (actually an oset of items... not an item-set structure).
;;; Empty out the set and re-insert the contents with closures.

(define (closure-1! item-set)
  (let* ((iset (oset-copy item-set)))
    (oset-empty! item-set)
    (oset-for-each
     (lambda (item)
       (let ((the-look-aheads (item-look-aheads item)))
	 (set-slot! (item-look-aheads item) 
	       (make-oset 'order-fn g-symbol-order-function))
	 (oset-for-each
	  (lambda (look-ahead)
	    (closure-1-insert-item! item look-ahead item-set))
	  the-look-aheads)))
     iset))
  #f)




(define (closure-1-insert-item! lr0-item look-ahead item-set)
  (let* ((insertion-result (oset-insert-2! lr0-item item-set))
         (item-not-there-already (car insertion-result))
         (the-item (cdr insertion-result)))
    (if (or (oset-insert! look-ahead
			  (item-look-aheads the-item))
	    item-not-there-already)
	;; Item wasn't already there with that lookahead
	;; so insert his buddies too.
	(for-each (lambda (prod)
		    (oset-for-each
		     (lambda (gs)
		       (closure-1-insert-item!
			(new-item prod)
			gs
			item-set))
		     (first-seq
		      (append
		       ;; This gets the list corresponding to the part
		       ;; of the item beyond the symbol after the dot.
		       (list-tail (item-production lr0-item)
				  (+ 2 (item-after-dot lr0-item)))
		       (list look-ahead)))))
		  (if (dot-at-right-end? lr0-item)
		      '()
		      (g-symbol-own-productions (symbol-after-dot
						 lr0-item)))))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; test:

(comment-out
 (load "closure1")
 (slurp-grammar "gram4")
 (calculate-empty-string-derivers)
 (calculate-first-sets)
 (define f-item (new-item (car (reverse productions))))
 (define f-i-set (single-item-closure-1
		  f-item the-end-g-symbol))
 (item-list-print (oset-item-list f-i-set))
 )


;;; PC scheme requires a control-Z at the end of each source file: 
