;;;             Copyright (C) 1989, by William M. Wells III
;;;                         All Rights Reserved
;;;     Permission is granted for unrestricted non-commercial use.

(declare (usual-integrations))

;;; Calculate the closure of an lr(0) set of items/
;;; I is an oset of items.
;;; This is non-destructive.

(define (closure I)
  (let ((eset (make-oset 'order-fn item-order-function)))
    (oset-for-each
     (lambda (x) (closure-insert-item! x eset))
     I)
    eset))

;;; Add an item to an oset of items. Add his pals too if he wasn't
;;; there already.  Evaluates to #t if it wasn't there already.

(define (closure-insert-item! item set)
  (if (oset-insert! item set)
      (begin
	(for-each
	 (lambda (production)
	   (closure-insert-item! (new-item production) set))
	 (if (dot-at-right-end? item)
	     '()
	     (g-symbol-own-productions (symbol-after-dot item))))
	#t)
      #f))


;;; PC scheme requires a control-Z at the end of each source file: 
