
;;;; Example modules

;; Test instantiation

(define m1
  (make-module
   'a (lambda (x) (+ x b))
   'b 3))

;; Test layering

(define m2
  (make-module 'a (lambda (x) (* x b))))

(define m3
  (make-module 'b 100))

(define m3.5
  (module-layer m3 m1))

(define m3.6
  (module-layer m2 m1))

;; Test freeze

(define m4
  (make-module
   'a (lambda (x) (+ 3 (f x)))
   'f (lambda (x) (* x c))
   'c 7))

(define m5
  (make-module 'c 100))

(define m7
  (module-union m5 (module-extract '(a) (module-freeze '(f) m4))))

(define m7.5
  (module-union
   (make-module 'f (lambda (x) (- x 1)))
   m7))

;; Test freeze better

(define m8
  (make-module
   'a (lambda (x) (f (+ x 1)))
   'f (lambda (x) (if (= x 0) 1 (* x (f (- x 1)))))))

(define m9
  (make-module 'f (lambda (x) 99)))

(define m10
  (module-union m9 (module-extract '(a) (module-freeze '(f) m8))))

;; Test rename

(define m11
  (module-rename '((q . f)) m4))

;; Test hide

(define m13
  (hide '(f) m4))

(define m14
  (module-union
   m13
   (make-module
    'f (lambda (x) (* x x)))))

;; Test freeze-except

(define m15
  (make-module
   'evenp (lambda (x) (trace x) (if (= x 0) #t (oddp (-1+ x))))
   'oddp (lambda (x) (trace x) (if (= x 0) #f (evenp (-1+ x))))
   'trace identity-procedure))

(define m16
  (module-layer
   (make-module 'trace write-line)
   (module-extract '(evenp) (module-freeze-except '(trace) m15))))

;; Test hide-except

(define m17
  (make-module
   'a (lambda (x) (display "a") (if (= x 0) () (b (-1+ x))))
   'b (lambda (x) (display "b") (if (= x 0) () (c (-1+ x))))
   'c (lambda (x) (display "c") (if (= x 0) () (a (-1+ x))))))

(define m18
  (module-layer
   (make-module
    'a (lambda (x) (display "z") (if (= x 0) () (b (-1+ x)))))
   (module-hide-except '(b) m17)))

(define m19
  (module-layer
   (make-module
    'a (lambda (x) (display "z") (if (= x 0) () (b (-1+ x)))))
   (module-hide-except '(a b) m17)))

;; Test state

(define m20
  (make-module
   'add (lambda (x) (set! total (+ total x)) total)
   'total 0))

(define m21
  (make-module
   'add1 (lambda () (set! total (+ total 1)) total)
   'add2 (lambda () (set! total (+ total 2)) total)
   'total 0))

