;;; -*- Base: 10; Mode: Scheme; Syntax: MIT Scheme; Package: USER -*-
;;
;; UTIL.SCM
;;
;; Minghsun Liu
;; July 10, 1991
;;
;; Some utility to go with Cooper.Scm
;;
(defmacro (tt #!rest x)
  `(let ((st (runtime)))
     ,@x
     (- (runtime) st)))

;;
;; (TIME X)
;;
;; try to give something similar to TIME in CL.  The time returned are
;; in milliseconds.  
;;
(defmacro (time #!rest x)
  `(time-aux (lambda () ,@x)))

(define (time-aux thunk)
  (let ((original-gc-stat (gc-statistics))
        (process-start (process-time-clock))
	(real-start (real-time-clock)))
    (let ((value (thunk)))
      (let ((process-end (process-time-clock))
	    (real-end (real-time-clock)))
	(newline)
	(for-each 
	 (lambda (stat) (write-string (gc-statistic->string stat)) (newline)) 
	 (list-transform-negative 
	     (gc-statistics) 
	   (lambda (a) (member a original-gc-stat))))
        (write-string "process time: ")
        (write (- process-end process-start))
        (write-string "; real time: ")
        (write (- real-end real-start)))
      value)))
