;;; -*- Base: 10; Mode: Scheme; Syntax: MIT Scheme; Package: USER-*-
;;
;; MARCO-HACKS.SCM
;;
;; June 29, 1991
;; Minghsun Liu
;;
;; This file contains some definitions taken from the file `Macros in
;; MIT Scheme' that makes the macros in MIT Scheme behave more like
;; that in CommonLisp.
;;
;; P.S. Since I am still not sure if the macros in Scheme support
;; destructuring, I am using the variable name CRUDE-INPUT in any
;; macros that used destructuring in the original CommonLisp to
;; represent those arguments.  The destructuring is then done by the
;; program itself.  - lmh
;;
;;
;; The following(s) are(is) defined:
;;
;; (DEFMACRO PATTERN . BODY)
;; 
(declare (usual-integrations))

;;
;; (DEFMACRO PATTERN . BODY)
;;
;; is a MIT Scheme macro that allows a macro defined in a file to be
;; available for use both in a given file and the REP loop.
;;
(define-macro (defmacro pattern . body)
  `(begin
     (define-macro ,pattern ,@body)
     (syntax-table-define user-initial-syntax-table ',(car pattern)
                          (macro ,(cdr pattern) ,@body))))

;;
;; What follows allows a macro to be available in a given file, in the
;; REP loop, and in source files loaded into (or compiled by) the
;; Scheme system.
;;
(syntax-table-define system-global-syntax-table 'defmacro
  (macro (pattern . body)
    `(begin
       (define-macro ,pattern ,@body)
       (syntax-table-define system-global-syntax-table ',(car pattern)
         (macro ,(cdr pattern)
           ,@body)))))
