; -*- Scheme -*-
;
; $Id: pathnamet01.scm,v 1.3 1993/02/20 19:37:14 bevan Exp $
;
;-------------
;
; Regression tests for SUBSTRING->UNIX:PATHNAME:DIRECTORY:TEST
;
;-------------

(require 'pathname:test:equal)
(require 'substring->unix:pathname:directory)

;-------------

(define substring->unix:pathname:directory:test
  (lambda ()
    
    (pathname:test:equal
     'substring->unix:pathname:directory-a
     (substring->unix:pathname:directory "/usr/bin" 0 8)
     '(root "usr" "bin"))

    (pathname:test:equal
     'substring->unix:pathname:directory-b
     (substring->unix:pathname:directory "usr/bin" 0 7)
     '(relative "usr" "bin"))

    (pathname:test:equal
     'substring->unix:pathname:directory-c
     (substring->unix:pathname:directory "usr/../bin" 0 10)
     '(relative "usr" up "bin"))

    (pathname:test:equal
     'substring->unix:pathname:directory-d
     (substring->unix:pathname:directory "usr/../../bin" 0 13)
     '(relative "usr" up up "bin"))

    (pathname:test:equal
     'substring->unix:pathname:directory-e
     (substring->unix:pathname:directory "usr/..//../bin" 0 14)
     '(relative "usr" up up "bin"))

    (pathname:test:equal
     'substring->unix:pathname:directory-f
     (substring->unix:pathname:directory "usr/.././../bin" 0 15)
     '(relative "usr" up up "bin"))

    (pathname:test:equal
     'substring->unix:pathname:directory-g
     (substring->unix:pathname:directory "usr/../.foo/../bin" 0 18)
     '(relative "usr" up ".foo" up "bin"))

    (pathname:test:equal
     'substring->unix:pathname:directory-h
     (substring->unix:pathname:directory "usr/../.foo./../bin" 0 19)
     '(relative "usr" up ".foo." up "bin"))

    (pathname:test:equal
     'substring->unix:pathname:directory-i
     (substring->unix:pathname:directory "///bar////foo" 0 13)
     '(root "bar" "foo"))

    (pathname:test:equal
     'substring->unix:pathname:directory-j
     (substring->unix:pathname:directory "b/././f" 0 7)
     '(relative "b" "f"))

    (pathname:test:equal
     'substring->unix:pathname:directory-k
     (substring->unix:pathname:directory "./bar" 0 5)
     '(relative "bar"))

    (pathname:test:equal
     'substring->unix:pathname:directory-l
     (substring->unix:pathname:directory "./../bar" 0 8)
     '(relative up "bar"))

    (pathname:test:equal
     'substring->unix:pathname:directory-m
     (substring->unix:pathname:directory "../../bar" 0 9)
     '(relative up up "bar"))

    (pathname:test:equal
     'substring->unix:pathname:directory-n
     (substring->unix:pathname:directory ".././../bar" 0 11)
     '(relative up up "bar"))

    (pathname:test:equal
     'substring->unix:pathname:directory-o
     (substring->unix:pathname:directory "./././bar" 0 9)
     '(relative "bar"))

    ))

; eof
