; -*- Scheme -*-
;
; $Id: pathname18.scm,v 1.1 1993/02/19 00:55:11 bevan Exp $

(require 'pathname:+directory)
(require 'substring->unix:pathname:directory)

;------------

;+doc
; procedure: unix:pathname:+directory-string
; arguments: pathname directory
; signature: pathname x string -> pathname
;
; Creates a new UNIX pathname consisting of PATHNAME with the directory
; overriden with DIRECTORY.
;-doc

(define unix:pathname:+directory-string
  (lambda (p d)
    (let ((cd (substring->unix:pathname:directory d 0 (string-length d))))
      (pathname:+directory p cd))))

; eof
