; -*- Scheme -*-
;
; $Id: pathname15.scm,v 1.1 1993/02/19 00:57:29 bevan Exp $

(require 'pathname:make)
(require 'pathname:host)
(require 'pathname:device)
(require 'pathname:directory)
(require 'pathname:name)
(require 'pathname:type)
(require 'pathname:version)

;------------

; procedure: pathname::update
; arguments: pathname host device directory name type version
; signature: pathname 
;          x (pathname:host -> pathname:host)
;          x (pathname:device -> pathname:device)
;          x (pathname:directory -> pathname:directory)
;          x (pathname:name -> pathname:name)
;          x (pathname:type -> pathname:type)
;          x (pathname:version -> pathname:version)
;         -> pathname

(define pathname::update
  (lambda (p host device directory name type version)
    (pathname:make
      (host (pathname:host p))
      (device (pathname:device p))
      (directory (pathname:directory p))
      (name (pathname:name p))
      (type (pathname:type p))
      (version (pathname:version p)))))

;------------
;exports pathname::update

; eof
