; -*- Scheme -*-
;
; $Id: pathname06.scm,v 1.1 1993/02/18 23:39:17 bevan Exp $

;+doc
; procedure: unix:pathname:directory->string
; arguments: directory
; signature: pathname:directory -> string
;
; Converts DIRECTORY into a string suitable for a UNIX system.
;-doc

(define unix:pathname:directory->string
  (lambda (pd)
    (if (not pd)
	""
	(case (car pd)
	  ((root) (unix:pathname:directory->string:: (cdr pd) "/"))
	  ((relative) (unix:pathname:directory->string:: (cdr pd) ""))
	  (else
	   (error 'unix:pathname:directory->string "duff directory spec."))))))

;------------

; procedure: unix:pathname:directory->string::
; arguments: list
; signature: list[symbol|string] -> string
; pre:       (andmap (lambda (e) (if (symbol? e) (eq? 'up e) #t)) list)

(define unix:pathname:directory->string::
  (lambda (pd r)
    (if (null? pd)
	r
	(let ((rs (if (string? (car pd)) (string-append (car pd) "/") "../")))
	  (unix:pathname:directory->string:: (cdr pd) (string-append r rs))))))

; eof
