;;
;; cw.sch
;;
;; Scheme header file for Scheme->C.  For other schemes you can just
;; change the define-*'s to define and load this file once.
;;

(define-constant **core-size** 4096)

(define-in-line (inc x) (+ x 1))
(define-in-line (dec x) (- x 1))

(define-in-line (make-table)
  (list '*table*))

(define-in-line (insert! key value table)
  (let ((record (assq key (cdr table))))
    (if record
	(set-cdr! record value)
	(set-cdr! table
		  (cons (cons key value) (cdr table))))))

(define-in-line (lookup key table)
  (let ((record (assq key (cdr table))))
    (if (null? record)
		#f
		(cdr record))))

(define-constant relative-mode-value 0)
(define-constant immediate-mode-value 1)
(define-constant indirect-mode-value 2)

(define-in-line (program-name p)
  (and (vector? p) (eq? (vector-ref p 0) 'program)))
(define-in-line (program? p) (vector-ref p 1))
(define-in-line (program? p) (and (vector? p) (eq? (vector-ref p 0) 'program)))
(define-in-line (program-name p) (vector-ref p 1))
(define-in-line (number-of-pcs p) (vector-ref p 2))
(define-in-line (current-pc-number p) (vector-ref p 3))
(define-in-line (current-pc p) (list-ref (pc-list p) (vector-ref p 3)))
(define-in-line (pc-list p) (vector-ref p 4))
(define-in-line (program-code p) (vector-ref p 6))
(define-in-line (program-text p) (vector-ref p 5))

(define-external (next-pc! p) program)
(define-external (abort-current-program! p) program)
(define-external (set-current-pc! p to) program)

(define-external (inc-current-pc! p) program)

(define-external (add-pc! p pc) program)

(define-external (make-core) core)

;; scale numbers to core
(define-in-line (scale-to-core x)
  (cond ((>= x **core-size**) (- x **core-size**))
        ((< x 0) (+ x **core-size**))
        (else x)))

(define-external (vector-copy! to at from) util)
(define-external (foreach-while l f) util)
(define-external (foreach l f) util)
(define-external (replace-nth! l n x) util)
(define-external (delete-nth! l n) util)
(define-external (delete x l) util)
(define-external (random n) util)
(define-external (flush-output-port) util)
