;; implementation of CORE
;;
;; words in core are stored as length 5 vectors
;; #(opcode mode-a operand-a mode-b operand-b)
;;

(module core)
(include "cw.sch")

(define (make-core-word value address)
  (let ((protected? #f)
	(self #f))
    (set! self
   	  (lambda (m)
	    (case m
	      ((unprotect) (set! protected? #f))
	      ((protect) (set! protected? #t))
	      ((protected?) protected?)
	      ((opcode) (vector-ref value 0))
	      ((mode-a) (vector-ref value 1))
	      ((operand-a) (vector-ref value 2))
	      ((mode-b) (vector-ref value 3))
	      ((operand-b) (vector-ref value 4))
	      ((write)
	       (lambda (word)
		 (if protected?
		     (self 'unprotect)
		     (set! value word))))
	      ((read) value)
	      ((address) address)
	      (else
	       (error "Uknown message to a core-word:" m)))))
    self))

;;
;; return a new CORE
;;
(define (make-core)
  (define (iter v i)
    (if (= i **core-size**)
	v
	(begin
	  (vector-set! v i (make-core-word (vector 0 0 0 0 0) i))
	  (iter v (inc i)))))
  (iter (make-vector **core-size**) 0))
